/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.validators;

import java.nio.file.Path;
import melnorme.lang.utils.validators.PathValidator;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.validation.ValidationException;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.status.StatusException;

public class LocationValidator
extends PathValidator
implements Validator<String, Path> {
    public final Validator<String, Location> asLocationValidator = new Validator<String, Location>(){

        @Override
        public Location validateField(String value) throws StatusException {
            return LocationValidator.this.getValidatedLocation(value);
        }
    };

    public LocationValidator(String fieldNamePrefix) {
        super(fieldNamePrefix);
    }

    public LocationValidator(String fieldNamePrefix, PathValidator.LocationKind locKind) {
        super(fieldNamePrefix, locKind);
    }

    @Override
    public Path validateField(String pathString) throws ValidationException {
        return this.getValidatedLocation((String)pathString).path;
    }

    public Validator<String, Location> asLocationValidator() {
        return this.asLocationValidator;
    }

    public static class LocationValidator2
    implements Validator<String, Location> {
        protected final LocationValidator validator;

        public LocationValidator2(String fieldNamePrefix) {
            this(new LocationValidator(fieldNamePrefix));
        }

        public LocationValidator2(LocationValidator pathValidator) {
            this.validator = Assert.AssertNamespace.assertNotNull(pathValidator);
        }

        @Override
        public Location validateField(String pathString) throws StatusException {
            return this.validator.getValidatedLocation(pathString);
        }
    }
}

