/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.validators;

import melnorme.lang.utils.validators.ValidationMessages;
import melnorme.utilbox.core.CommonException;

public class NumberValidator {
    public int validateNonNegativeInteger(String numberString) throws CommonException {
        int intValue = this.validateInteger(numberString);
        if (intValue < 0) {
            throw CommonException.fromMsgFormat(ValidationMessages.Number_IsNegative, intValue);
        }
        return intValue;
    }

    public int validateInteger(String numberString) throws CommonException {
        if (numberString == null || numberString.length() == 0) {
            throw new CommonException(ValidationMessages.NumberField_empty_input);
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException e) {
            throw CommonException.fromMsgFormat(ValidationMessages.NumberField_invalid_input2, numberString);
        }
    }

    public int getIntegerFrom(String numberString) {
        try {
            return this.validateInteger(numberString);
        }
        catch (CommonException e) {
            return 0;
        }
    }
}

