/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.validators;

import java.nio.file.Path;
import melnorme.lang.utils.validators.AbstractValidatorExt;
import melnorme.lang.utils.validators.ValidationMessages;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.validation.ValidationException;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.status.Severity;

public class PathValidator
extends AbstractValidatorExt
implements Validator<String, Path> {
    public final String fieldNamePrefix;
    public boolean canBeEmpty;
    public boolean fileOnly = false;
    public boolean directoryOnly = false;

    public PathValidator(String fieldNamePrefix) {
        this(fieldNamePrefix, LocationKind.ANY);
    }

    public PathValidator(String fieldNamePrefix, LocationKind locKind) {
        this.fieldNamePrefix = fieldNamePrefix;
        this.canBeEmpty = false;
        this.fileOnly = locKind == LocationKind.FILE_ONLY;
        this.directoryOnly = locKind == LocationKind.DIR_ONLY;
    }

    public PathValidator setFileOnly(boolean fileOnly) {
        this.fileOnly = fileOnly;
        return this;
    }

    public PathValidator setDirectoryOnly(boolean directoryOnly) {
        this.directoryOnly = directoryOnly;
        return this;
    }

    protected LocationKind getLocationKind() {
        return this.fileOnly ? LocationKind.FILE_ONLY : (this.directoryOnly ? LocationKind.DIR_ONLY : LocationKind.ANY);
    }

    @Override
    protected String getFullMessage(String simpleMessage) {
        return String.valueOf(this.fieldNamePrefix) + " " + super.getFullMessage(simpleMessage);
    }

    @Override
    public Path validateField(String pathString) throws ValidationException {
        return this.getValidatedPath(pathString);
    }

    public Path getValidatedPath(String pathString) throws ValidationException {
        return this.validatePath(this.createPath(pathString));
    }

    protected Path createPath(String pathString) throws ValidationException {
        if (pathString.isEmpty()) {
            if (this.canBeEmpty) {
                return null;
            }
            throw this.createIsEmptyException();
        }
        Path path = PathUtil.createPathOrNull(pathString);
        if (path == null) {
            throw this.createException(Severity.ERROR, ValidationMessages.Path_InvalidPath(pathString));
        }
        return path;
    }

    protected ValidationException createIsEmptyException() {
        return this.createException(Severity.WARNING, ValidationMessages.Path_EmptyPath());
    }

    protected Path validatePath(Path path) throws ValidationException {
        if (path.isAbsolute()) {
            return PathUtil.toPath(this.getValidatedLocation(path));
        }
        return this.validateRelativePath(path);
    }

    protected Path validateRelativePath(Path path) throws ValidationException {
        return path;
    }

    public Location getValidatedLocation(String pathString) throws ValidationException {
        return this.getValidatedLocation(this.createPath(pathString));
    }

    protected Location getValidatedLocation(Path path) throws ValidationException {
        Location location;
        try {
            location = Location.create(path);
        }
        catch (CommonException ce) {
            throw this.error_NotAbsolute(path);
        }
        return this.validateLocation(location);
    }

    protected ValidationException error_NotAbsolute(Path path) throws ValidationException {
        return this.createException(Severity.ERROR, ValidationMessages.Location_NotAbsolute(path));
    }

    protected Location validateLocation(Location location) throws ValidationException {
        this.validateLocation(location, this.getLocationKind());
        return this.getValidatedField_rest(location);
    }

    protected void validateLocation(Location location, LocationKind locKind) throws ValidationException {
        if (!location.toFile().exists()) {
            throw this.createException(Severity.WARNING, ValidationMessages.Location_DoesntExist(location));
        }
        this.validateType(location, locKind);
    }

    public void validateType(Location location, LocationKind locKind) throws ValidationException {
        if (locKind == LocationKind.FILE_ONLY && !location.toFile().isFile()) {
            throw this.createException(Severity.WARNING, ValidationMessages.Location_NotAFile(location));
        }
        if (locKind == LocationKind.DIR_ONLY && !location.toFile().isDirectory()) {
            throw this.createException(Severity.WARNING, ValidationMessages.Location_NotADirectory(location));
        }
    }

    protected Location getValidatedField_rest(Location location) throws ValidationException {
        return location;
    }

    public static enum LocationKind {
        ANY,
        FILE_ONLY,
        DIR_ONLY;

    }
}

