/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import melnorme.utilbox.collections.ArrayViewImpl;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;

public abstract class ArrayView<E>
implements Indexable<E> {
    public static final ArrayView<?> EMPTY_ARRAYVIEW = new ArrayViewImpl<Object>(new Object[0]);
    protected final E[] array;

    @SafeVarargs
    public static <T> ArrayView<T> createFrom(T ... arr) {
        return new ArrayViewImpl<T>(arr);
    }

    public static <T> ArrayView<T> create(T[] arr) {
        return new ArrayViewImpl<T>(arr);
    }

    public ArrayView(E[] array) {
        Assert.AssertNamespace.assertNotNull(array);
        this.array = array;
    }

    public boolean equals(Object obj) {
        return Indexable.equals(this, obj);
    }

    public int hashCode() {
        return Indexable.hashCode(this);
    }

    @Override
    public <T> ArrayView<T> upcastTypeParameter() {
        return (ArrayView)CoreUtil.blindCast(this);
    }

    @Override
    public final int size() {
        return this.array.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public final E get(int index) {
        return this.array[index];
    }

    @Override
    public final Iterator<E> iterator() {
        return new ArrayIterator();
    }

    @Override
    public Object[] copyToArray(Object[] destArray) {
        System.arraycopy(this.array, 0, destArray, 0, this.array.length);
        return destArray;
    }

    public final E[] getInternalArray() {
        return this.array;
    }

    public final <T> T[] _getInternalArray(Class<T> componentType) {
        return this.array;
    }

    public final class ArrayIterator
    implements Iterator<E> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ArrayView.this.array.length;
        }

        @Override
        public E next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayView.this.array[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

