/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.Collection;
import java.util.HashSet;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.ArrayUtil;

public class HashSet2<E>
extends HashSet<E>
implements Collection2<E> {
    private static final long serialVersionUID = -7612795787860334443L;

    public HashSet2() {
    }

    public HashSet2(Collection<? extends E> coll) {
        super(coll);
    }

    public HashSet2(Indexable<? extends E> coll) {
        super(coll.size());
        this.addAll2(coll);
    }

    public HashSet2(Iterable<? extends E> coll) {
        this.addAll2(coll);
    }

    public HashSet2(int initialCapacity) {
        super(initialCapacity);
    }

    @SafeVarargs
    public HashSet2(E ... elements) {
        this.addElements(elements);
    }

    @SafeVarargs
    public final HashSet2<E> addElements(E ... elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.add(element);
            ++n2;
        }
        return this;
    }

    public final HashSet2<E> addAll2(Iterable<? extends E> elements) {
        for (E element : elements) {
            this.add(element);
        }
        return this;
    }

    public final HashSet2<E> removeAll2(Iterable<? extends E> elements) {
        for (E element : elements) {
            this.remove(element);
        }
        return this;
    }

    @Override
    public E[] toArray(Class<E> componentType) {
        return ArrayUtil.createFrom(this, componentType);
    }

    @Override
    public <T> HashSet2<T> upcastTypeParameter() {
        return (HashSet2)CoreUtil.blindCast(this);
    }

    private static void _generics_test() {
        HashSet2 arrayListExt = new HashSet2();
        ((HashSet2)arrayListExt.upcastTypeParameter()).toArray(Number.class);
        ArrayUtil.createFrom(arrayListExt, Number.class);
    }
}

