/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.iter.ImmutableListIterator;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.CollectionUtil;

public interface Indexable<E>
extends Collection2<E>,
RandomAccess {
    public static final Indexable EMPTY_INDEXABLE = new ArrayList2();

    public E get(int var1);

    @Override
    public <T> Indexable<T> upcastTypeParameter();

    default public int indexOf(Object obj) {
        int ix = 0;
        while (ix < this.size()) {
            if (CoreUtil.areEqual(obj, this.get(ix))) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    default public int lastIndexOf(Object obj) {
        int ix = this.size() - 1;
        while (ix >= 0) {
            if (CoreUtil.areEqual(obj, this.get(ix))) {
                return ix;
            }
            --ix;
        }
        return -1;
    }

    default public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    default public ListIterator<E> listIterator() {
        return new ImmutableListIterator(this, 0);
    }

    default public ListIterator<E> listIterator(int index) {
        return new ImmutableListIterator(this, index);
    }

    public static <T> Indexable<T> nullToEmpty(Indexable<T> indexable) {
        return indexable == null ? CollectionUtil.EMPTY_INDEXABLE : indexable;
    }

    public static boolean equals(Indexable<?> collA, Object other) {
        if (collA == other) {
            return true;
        }
        if (other instanceof Indexable) {
            return Indexable.indexableEquals(collA, (Indexable)other);
        }
        if (collA instanceof List && other instanceof List) {
            return CollectionUtil.listEquals((List)((Object)collA), (List)other);
        }
        return false;
    }

    public static boolean indexableEquals(Indexable<?> coll1, Indexable<?> coll2) {
        if (coll1.size() != coll2.size()) {
            return false;
        }
        return CollectionUtil.iterationEquals(coll1.iterator(), coll2.iterator());
    }

    public static int hashCode(Indexable<?> indexable) {
        int hashCode = 1;
        for (Object element : indexable) {
            hashCode = 31 * hashCode + (element == null ? 0 : element.hashCode());
        }
        return hashCode;
    }
}

