/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections.iter;

import java.util.List;
import melnorme.utilbox.collections.iter.ICopyableIterator;
import melnorme.utilbox.core.Assert;

public class CopyableListIterator<T>
implements ICopyableIterator<T> {
    protected final List<T> list;
    protected int index = 0;

    public static <U> CopyableListIterator<U> create(List<U> list) {
        return new CopyableListIterator<U>(list);
    }

    public CopyableListIterator(List<T> list) {
        this(list, 0);
    }

    public CopyableListIterator(List<T> list, int index) {
        this.list = Assert.AssertNamespace.assertNotNull(list);
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public T next() {
        return this.list.get(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICopyableIterator<T> copyState() {
        return new CopyableListIterator<T>(this.list, this.index);
    }

    @Override
    public ICopyableIterator<T> optimizedSelf() {
        return this;
    }
}

