/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.CountDownLatch;
import melnorme.utilbox.concurrency.OperationCancellation;

public interface ICancelMonitor {
    public boolean isCanceled();

    default public void checkCancellation() throws OperationCancellation {
        ICancelMonitor.checkCancelation(this);
    }

    public static void checkCancelation(ICancelMonitor cm) throws OperationCancellation {
        if (cm.isCanceled()) {
            throw new OperationCancellation();
        }
    }

    public static class CancelMonitor
    implements ICancelMonitor {
        protected volatile boolean isCancelled = false;
        protected final CountDownLatch cancelLatch = new CountDownLatch(1);

        @Override
        public boolean isCanceled() {
            return this.isCancelled;
        }

        public CountDownLatch getCancelLatch() {
            return this.cancelLatch;
        }

        public void cancel() {
            this.isCancelled = true;
            this.cancelLatch.countDown();
        }
    }

    public static class NullCancelMonitor
    implements ICancelMonitor {
        @Override
        public boolean isCanceled() {
            return false;
        }
    }
}

