/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.CountDownLatch;
import melnorme.utilbox.core.ExceptionAdapter;

public class LatchRunnable
implements Runnable,
AutoCloseable {
    public final CountDownLatch entryLatch = new CountDownLatch(1);
    public final CountDownLatch exitLatch = new CountDownLatch(1);
    public final boolean retryAwait;

    public LatchRunnable() {
        this(false);
    }

    public LatchRunnable(boolean retryAwait) {
        this.retryAwait = retryAwait;
    }

    @Override
    public void run() {
        this.entryLatch.countDown();
        while (true) {
            try {
                this.exitLatch.await();
                return;
            }
            catch (InterruptedException e) {
                if (this.retryAwait) continue;
                return;
            }
            break;
        }
    }

    public void awaitTaskEntry() throws InterruptedException {
        this.entryLatch.await();
    }

    public void awaitTaskEntry_unchecked() {
        try {
            this.entryLatch.await();
        }
        catch (InterruptedException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public void releaseAll() {
        this.entryLatch.countDown();
        this.exitLatch.countDown();
    }

    @Override
    public void close() {
        this.releaseAll();
    }
}

