/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.HashSet2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.FunctionX;

public class CollectionUtil {
    public static final Indexable EMPTY_INDEXABLE = new ArrayList2();

    public static <T> Indexable<T> nullToEmpty(Indexable<T> indexable) {
        return Indexable.nullToEmpty(indexable);
    }

    public static <E> ArrayList2<E> createArrayList(Iterable<? extends E> iterable) {
        return new ArrayList2<E>(CollectionUtil.nullToEmpty(iterable));
    }

    public static <E> LinkedList<E> createLinkedList(Iterable<? extends E> iterable) {
        return CollectionUtil.addAll2(new LinkedList(), CollectionUtil.nullToEmpty(iterable));
    }

    public static <E> HashSet2<E> createHashSet(Iterable<? extends E> iterable) {
        return new HashSet2<E>(CollectionUtil.nullToEmpty(iterable));
    }

    @SafeVarargs
    public static <E> ArrayList2<E> createArrayList(E ... array) {
        ArrayList2 newCollection = new ArrayList2();
        if (array != null) {
            Collections.addAll(newCollection, array);
        }
        return newCollection;
    }

    @SafeVarargs
    public static <E> LinkedList<E> createLinkedList(E ... array) {
        LinkedList newCollection = new LinkedList();
        if (array != null) {
            Collections.addAll(newCollection, array);
        }
        return newCollection;
    }

    @SafeVarargs
    public static <E> HashSet2<E> createHashSet(E ... array) {
        HashSet2 newCollection = new HashSet2();
        if (array != null) {
            Collections.addAll(newCollection, array);
        }
        return newCollection;
    }

    public static <E> Iterable<E> nullToEmpty(Iterable<E> iterable) {
        return iterable == null ? Collections.EMPTY_LIST : iterable;
    }

    public static <E> Collection<E> nullToEmpty(Collection<E> coll) {
        return coll == null ? Collections.EMPTY_LIST : coll;
    }

    public static <E> List<E> nullToEmpty(List<E> list) {
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public static <T> int indexOfSame(Iterable<? extends T> iterable, T obj) {
        return CollectionUtil.indexOfSame(iterable.iterator(), obj);
    }

    public static <T> int indexOfSame(Iterator<? extends T> iterator, T obj) {
        int ix = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (element == obj) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static <T> int indexOf(Iterable<? extends T> iterable, T obj) {
        return CollectionUtil.indexOf(iterable.iterator(), obj);
    }

    public static <T> int indexOf(Iterator<? extends T> iterator, T obj) {
        int ix = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (CoreUtil.areEqual(element, obj)) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static <T> int indexUntil(Iterator<? extends T> iterator, Predicate<T> predicate) {
        int ix = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (predicate.test(element)) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static <T> T findElement(Iterator<? extends T> iterator, Predicate<? super T> predicate) {
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static boolean containsSame(Iterable<?> coll, Object obj) {
        for (Object element : coll) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll, Collection<?> other) {
        for (Object otherElement : other) {
            if (coll.contains(otherElement)) continue;
            return false;
        }
        return true;
    }

    public static <T> T getSingleElementOrNull(Iterable<T> coll) {
        if (coll == null) {
            return null;
        }
        Iterator<T> iterator = coll.iterator();
        T firstElement = iterator.next();
        return iterator.hasNext() ? null : (T)firstElement;
    }

    public static <E> ArrayList2<E> copyExcept(E[] orig, E excludedElem) {
        ArrayList2<E> rejectedElements = new ArrayList2<E>(orig.length);
        int i = 0;
        while (i < orig.length) {
            if (!orig[i].equals(excludedElem)) {
                rejectedElements.add(orig[i]);
            }
            ++i;
        }
        return rejectedElements;
    }

    public static <ELEM, COLL extends Collection<? super ELEM>> COLL addAll2(COLL dest, Iterable<? extends ELEM> source) {
        return CollectionUtil.addAllFromIterator(dest, source.iterator());
    }

    public static <ELEM, COLL extends Collection<? super ELEM>> COLL addAllFromIterator(COLL dest, Iterator<? extends ELEM> source) {
        while (source.hasNext()) {
            dest.add(source.next());
        }
        return dest;
    }

    public static <ELEM, COLL extends Collection<? super ELEM>, SourceELEM> COLL addAll(COLL dest, Iterable<? extends SourceELEM> source, Function<SourceELEM, ELEM> mapper) {
        for (SourceELEM elem : source) {
            dest.add(mapper.apply(elem));
        }
        return dest;
    }

    public static <E, L extends List<E>> L filter(L list, Predicate<E> predicate) {
        Iterator<E> iter = list.iterator();
        while (iter.hasNext()) {
            E obj = iter.next();
            if (!predicate.test(obj)) continue;
            iter.remove();
        }
        return list;
    }

    public static <E> boolean removeElement(List<? extends E> list, Predicate<E> predicate) {
        Iterator<E> iter = list.iterator();
        while (iter.hasNext()) {
            E obj = iter.next();
            if (!predicate.test(obj)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public static <E extends Comparable<? super E>, L extends List<E>> L sort(L list) {
        Collections.sort(list);
        return list;
    }

    private static void sort__genericsTestCompile() {
        Object list1 = null;
        ArrayList list2 = null;
        list1 = CollectionUtil.sort(list1);
        list2 = CollectionUtil.sort(list2);
    }

    public static <E, R> ArrayList2<R> map(Iterable<E> coll, Function<? super E, ? extends R> evalFunction) {
        return CollectionUtil.mapTo(coll, evalFunction, new ArrayList2());
    }

    public static <E, R, DEST extends Collection<R>> DEST mapTo(Iterable<E> coll, Function<? super E, ? extends R> evalFunction, DEST destCollection) {
        for (E collElement : coll) {
            R mappeElem = evalFunction.apply(collElement);
            destCollection.add(mappeElem);
        }
        return destCollection;
    }

    public static <E, R, EXC extends Exception> ArrayList2<R> mapx(Iterable<E> coll, FunctionX<? super E, ? extends R, EXC> evalFunction) throws EXC {
        return CollectionUtil.mapxTo(coll, evalFunction, new ArrayList2());
    }

    public static <E, R, EXC extends Exception, DEST extends Collection<R>> DEST mapxTo(Iterable<E> coll, FunctionX<? super E, ? extends R, EXC> evalFunction, DEST destCollection) throws EXC {
        for (E collElement : coll) {
            R mappeElem = evalFunction.apply(collElement);
            destCollection.add(mappeElem);
        }
        return destCollection;
    }

    public static boolean listEquals(Indexable<?> coll1, Indexable<?> coll2) {
        return Indexable.indexableEquals(coll1, coll2);
    }

    public static boolean listEquals(List<?> coll1, List<?> coll2) {
        if (coll1.size() != coll2.size()) {
            return false;
        }
        return CollectionUtil.iterationEquals(coll1.iterator(), coll2.iterator());
    }

    public static boolean iterationEquals(Iterator<?> iter1, Iterator<?> iter2) {
        while (iter1.hasNext() && iter2.hasNext()) {
            Object o2;
            Object o1 = iter1.next();
            if (CoreUtil.areEqual(o1, o2 = iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }
}

