/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.IByteSequence;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StreamUtil;

public final class FileUtil {
    public static IByteSequence readBytesFromFile(File file) throws IOException {
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IOException("File is too large, size is bigger than 2147483647");
        }
        return StreamUtil.readAllBytesFromStream(new FileInputStream(file), (int)fileLength);
    }

    public static String readStringFromFile(File file, String charsetName) throws IOException {
        return FileUtil.readBytesFromFile(file).toString(Charset.forName(charsetName));
    }

    public static String readStringFromFile(File file, Charset charset) throws IOException {
        return FileUtil.readBytesFromFile(file).toString(charset);
    }

    public static String readStringFromFile(Path file, Charset charset) throws IOException {
        return FileUtil.readBytesFromFile(file.toFile()).toString(charset);
    }

    public static String readFileContents(Location location, Charset charset) throws CommonException {
        try {
            return FileUtil.readStringFromFile(location.toPath(), charset);
        }
        catch (IOException e) {
            throw new CommonException(e.getMessage(), e.getCause());
        }
    }

    public static void writeBytesToFile(File file, byte[] bytes) throws IOException {
        FileOutputStream fileOS = new FileOutputStream(file);
        StreamUtil.writeBytesToStream(bytes, fileOS);
    }

    public static void writeCharsToFile(File file, char[] chars, Charset charset) throws IOException, FileNotFoundException {
        FileOutputStream fileOS = new FileOutputStream(file);
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)fileOS, charset);
        StreamUtil.writeCharsToWriter(chars, osWriter);
    }

    public static void writeStringToFile(File file, String string, Charset charset) throws IOException, FileNotFoundException {
        FileOutputStream fileOS = new FileOutputStream(file);
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)fileOS, charset);
        StreamUtil.writeStringToWriter(string, osWriter);
    }

    public static void copyToDir(Path source, Path targetDir, CopyOption ... options) throws IOException {
        Files.copy(source, targetDir.resolve(source.getFileName()), options);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    public static void deleteDirContents(Path dir) throws IOException {
        FileUtil.deleteDirContents(Location.create_fromValid(dir), false);
    }

    @Deprecated
    public static void deleteDir(File dir) throws IOException {
        FileUtil.deleteDirContents(Location.create_fromValid(dir.toPath()));
    }

    @Deprecated
    public static void deleteDir(Path dir) throws IOException {
        FileUtil.deleteDirContents(Location.create_fromValid(dir));
    }

    public static void deleteDir(Location dir) throws IOException {
        FileUtil.deleteDirContents(dir, true);
    }

    public static void deleteDirContents(Location directory) throws IOException {
        FileUtil.deleteDirContents(directory, false);
    }

    protected static void deleteDirContents(final Location directory, final boolean deleteDirectory) throws IOException {
        if (!directory.toFile().exists()) {
            return;
        }
        Files.walkFileTree(directory.toPath(), EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory) || deleteDirectory) {
                    Files.deleteIfExists(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

