/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import melnorme.utilbox.collections.ChainedIterable;

public class IteratorUtil {
    public static final Iterator<?> EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();

    public static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <E> Iterable<E> emptyIterable() {
        return Collections.EMPTY_LIST;
    }

    public static <E> Iterator<E> recast(Iterator<? extends E> iterator) {
        return iterator;
    }

    public static <E> Iterator<E> singletonIterator(E obj) {
        return Collections.singletonList(obj).iterator();
    }

    public static <E> Iterator<E> nonNullIterator(Iterable<E> iterable) {
        return iterable == null ? Collections.emptyIterator() : iterable.iterator();
    }

    public static <E> Iterable<E> nonNullIterable(Iterable<E> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    @SafeVarargs
    public static <E> Iterable<E> iterable(E ... array) {
        if (array == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(array);
    }

    public static <E> Iterable<E> iterable(Iterable<E> iterable) {
        if (iterable == null) {
            return Collections.EMPTY_LIST;
        }
        return iterable;
    }

    public static <E> Iterable<? extends E> chainedIterable(Iterable<? extends E> firstIter, Iterable<? extends E> secondIter) {
        if (firstIter != null && secondIter != null) {
            return new ChainedIterable<E>(firstIter, secondIter);
        }
        if (firstIter != null) {
            return firstIter;
        }
        if (secondIter != null) {
            return secondIter;
        }
        return IteratorUtil.emptyIterable();
    }

    public static <E> E getCurrentElement(ListIterator<E> listIterator) {
        listIterator.previous();
        return listIterator.next();
    }
}

