/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.PathUtil;

public class Location {
    public final Path path;

    public static Location create_fromValid(Path path) {
        return Location.fromAbsolutePath(path);
    }

    public static Location fromAbsolutePath(Path absolutePath) {
        return new Location(absolutePath);
    }

    public static Location create(Path path) throws CommonException {
        return Location.createValidLocation(path, "Invalid location: ");
    }

    public static Location create(String pathString) throws CommonException {
        return Location.createValidLocation(pathString, "Invalid location: ");
    }

    public static Location createValidLocation(Path path, String errorMessagePrefix) throws CommonException {
        if (!path.isAbsolute()) {
            throw new CommonException(String.valueOf(errorMessagePrefix) + "Path `" + path.toString() + "` is not absolute.");
        }
        return new Location(path);
    }

    public static Location createValidLocation(String pathString, String errorMessagePrefix) throws CommonException {
        Path path = PathUtil.createPath(pathString, errorMessagePrefix);
        return Location.createValidLocation(path, errorMessagePrefix);
    }

    public static Location createValidOrNull(Path path) {
        if (path == null) {
            return null;
        }
        try {
            return Location.create(path);
        }
        catch (CommonException e) {
            return null;
        }
    }

    public static Location createValidOrNull(String pathString) {
        return Location.createValidOrNull(PathUtil.createPathOrNull(pathString));
    }

    public static Location create(Location baseLocation, String pathString) throws CommonException {
        Path path = PathUtil.createPath(pathString);
        return baseLocation.resolve(path);
    }

    public static Location validateLocation(Path filePath, boolean isRequired, String descText) throws CommonException {
        if (filePath == null) {
            if (isRequired) {
                throw new CommonException("Path not specified for " + descText + ".");
            }
            return null;
        }
        try {
            return Location.create(filePath);
        }
        catch (CommonException e) {
            throw new CommonException("Invalid location for " + descText + ", path not absolute: " + filePath);
        }
    }

    protected Location(Path absolutePath) {
        Assert.AssertNamespace.assertNotNull(absolutePath);
        Assert.AssertNamespace.assertTrue(absolutePath.isAbsolute());
        this.path = absolutePath.normalize();
    }

    public Path getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return CoreUtil.areEqual(this.path, other.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.toPathString();
    }

    public String toPathString() {
        return this.path.toString();
    }

    public Path toPath() {
        return this.path;
    }

    public File toFile() {
        return this.path.toFile();
    }

    public URI toUri() {
        return this.path.toUri();
    }

    public boolean isRoot() {
        return this.path.getNameCount() == 0;
    }

    public String getFileName() {
        Path fileName = this.path.getFileName();
        return fileName == null ? null : fileName.toString();
    }

    public Location resolve(String subPathStr) throws CommonException {
        Path subPath = PathUtil.createPath(subPathStr);
        return this.resolve(subPath);
    }

    public Location resolveOrNull(String otherPathString) {
        Path otherPath = PathUtil.createPathOrNull(otherPathString);
        if (otherPath == null) {
            return null;
        }
        return this.resolve(otherPath);
    }

    public Location resolve_fromValid(String otherPathString) {
        Path otherPath = PathUtil.createValidPath(otherPathString);
        return this.resolve(otherPath);
    }

    public Location resolve_valid(String otherPathString) {
        return this.resolve_fromValid(otherPathString);
    }

    public Location resolve(Path otherPath) {
        return Location.create_fromValid(this.path.resolve(otherPath));
    }

    public Location getParent() {
        Path parent = this.path.getParent();
        if (parent == null) {
            return null;
        }
        return Location.create_fromValid(parent);
    }

    public boolean startsWith(Location otherLoc) {
        return this.path.startsWith(otherLoc.path);
    }

    public Path relativize(Location packageLoc) {
        return this.path.relativize(packageLoc.path);
    }
}

