/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.ExceptionAdapter;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.misc.StreamUtil;
import melnorme.utilbox.misc.StringUtil;

public class MiscUtil
extends PathUtil {
    public static final String OS_NAME = StringUtil.nullAsEmpty(System.getProperty("os.name"));
    public static final boolean OS_IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean OS_IS_LINUX = OS_NAME.startsWith("Linux") || OS_NAME.startsWith("LINUX");
    public static final boolean OS_IS_MAC = OS_NAME.startsWith("Mac");

    public static <T> Optional<T> toOptional(Optional<T> project) {
        return project == null ? Optional.empty() : project;
    }

    public static String getExecutableSuffix() {
        return OS_IS_WINDOWS ? ".exe" : "";
    }

    public static String getSystemProperty(String propName, String defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        return propValue;
    }

    public static boolean getSystemProperty(String propName, boolean defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        return propValue != null;
    }

    public static boolean parseBoolean(String string) {
        return string == null ? false : Boolean.valueOf(string);
    }

    public static <T> Predicate<T> getNotNullPredicate() {
        return new NotNullPredicate();
    }

    public static <T> Predicate<T> getIsNullPredicate() {
        return new IsNullPredicate();
    }

    public static void loadClass(Class<?> klass) {
        try {
            Class.forName(klass.getName(), true, klass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Assert.AssertNamespace.assertFail();
        }
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return HashcodeUtil.combineHashCodes(hashCode1, hashCode2);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... objs) {
        int i = 0;
        while (i < objs.length) {
            if (objs[i] != null) {
                return objs[i];
            }
            ++i;
        }
        Assert.AssertNamespace.assertFail();
        return null;
    }

    public static <T> T getSingleElement(Collection<T> singletonDefunits) {
        Assert.AssertNamespace.assertTrue(singletonDefunits.size() == 1);
        return singletonDefunits.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Iterable<T> synchronizedCreateIterable(Collection<T> collection) {
        ArrayList<T> iterable;
        Collection<T> collection2 = collection;
        synchronized (collection2) {
            iterable = new ArrayList<T>(collection);
        }
        return iterable;
    }

    public static void sleepUnchecked(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static <T> T nullToOther(T object, T altValue) {
        return object == null ? altValue : object;
    }

    public static boolean isUncheckedException(Throwable throwable) {
        return throwable instanceof RuntimeException || throwable instanceof Error;
    }

    public static String getClassResource(Class<?> klass, String resourceName) {
        return MiscUtil.getClassResource(klass, resourceName, StringUtil.UTF8);
    }

    public static String getClassResource(Class<?> klass, String resourceName, Charset charset) {
        try {
            InputStream resourceStream = klass.getResourceAsStream(resourceName);
            Assert.AssertNamespace.assertNotNull(resourceStream);
            return StreamUtil.readAllBytesFromStream(resourceStream).toString(charset);
        }
        catch (IOException e) {
            throw Assert.AssertNamespace.assertFail();
        }
    }

    public static final class IsNullPredicate<T>
    implements Predicate<T> {
        @Override
        public boolean test(T obj) {
            return obj == null;
        }
    }

    public static final class NotNullPredicate<T>
    implements Predicate<T> {
        @Override
        public boolean test(T obj) {
            return obj != null;
        }
    }
}

