/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;

public final class Pair<T1, T2> {
    private final T1 first;
    private final T2 second;

    public static <T1, T2> Pair<T1, T2> create(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public Object getElement(int n) {
        return n == 0 ? this.first : this.second;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return CoreUtil.areEqual(this.first, other.first) && CoreUtil.areEqual(this.second, other.second);
    }

    public int hashCode() {
        return HashcodeUtil.combineHashCodes(this.first.hashCode(), this.second.hashCode());
    }

    public String toString() {
        return "<" + this.getFirst() + "," + this.getSecond() + ">";
    }
}

