/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;

public class PathUtil {
    public static final Path DEFAULT_ROOT_PATH = PathUtil.createValidPath("").toAbsolutePath().getRoot();
    public static final Location DEFAULT_ROOT_LOC = Location.fromAbsolutePath(DEFAULT_ROOT_PATH);

    public static Path createPathOrNull(String pathString) {
        try {
            return Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException ipe) {
            return null;
        }
    }

    public static Path createValidPath(String pathString) {
        try {
            return Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException ipe) {
            throw Assert.AssertNamespace.assertFail();
        }
    }

    public static Path createPath(String pathString) throws CommonException {
        return PathUtil.createPath(pathString, "Invalid path: ");
    }

    public static Path createResolvedPath(String basePath, String subPath) throws CommonException {
        return PathUtil.createPath(basePath).resolve(PathUtil.createPath(subPath)).normalize();
    }

    public static Path createPath(String pathString, String errorMessagePrefix) throws CommonException {
        try {
            return Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException ipe) {
            String pathMessage = ipe.getMessage();
            if (pathMessage == null) {
                pathMessage = ipe.toString();
            }
            throw new CommonException(String.valueOf(errorMessagePrefix) + pathMessage);
        }
    }

    public static Path getParentOrEmpty(Path path) throws CommonException {
        Path parent = path.getParent();
        return parent == null ? PathUtil.createValidPath("") : parent;
    }

    public static Path toPath(Location location) {
        return location == null ? null : location.toPath();
    }

    public static String concatenatePath(String basePath, String subPath) {
        return PathUtil.concatenatePath(basePath, subPath, File.separator);
    }

    public static String concatenatePath(String basePath, String subPath, String separator) {
        if (basePath.isEmpty()) {
            return subPath;
        }
        if (!basePath.endsWith(separator)) {
            basePath = String.valueOf(basePath) + separator;
        }
        return String.valueOf(basePath) + subPath;
    }
}

