/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.ExceptionAdapter;

public class ReflectionUtils {
    public static Object newInstanceSafe(String klassName) {
        Class<?> klass = ReflectionUtils.loadClassSafe(klassName);
        return klass == null ? null : ReflectionUtils.newInstanceSafe(klass);
    }

    public static Object newInstanceSafe(Class<?> klass) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Class<?> loadClassSafe(String klassName) {
        try {
            return Class.forName(klassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method uncheckedGetMethod(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (SecurityException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static <T> T uncheckedInvoke(Object obj, Method method, Object ... args) {
        try {
            Object result = method.invoke(obj, args);
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionAdapter.unchecked(e.getTargetException());
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        try {
            Class[] paramTypes = new Class[args.length];
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = args[i].getClass();
                ++i;
            }
            Method method = ReflectionUtils.getAvailableMethod(obj.getClass(), methodName, paramTypes);
            Object result = method.invoke(obj, args);
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionAdapter.unchecked(e.getTargetException());
        }
    }

    public static Method getAvailableMethod(Class<?> klass, String methodName, Class<?> ... paramTypes) {
        try {
            return klass.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return ReflectionUtils.getDeclaredMethodInHierarchy(klass, methodName, paramTypes);
        }
    }

    private static Method getDeclaredMethodInHierarchy(Class<?> klass, String methodName, Class<?> ... paramTypes) {
        try {
            Method field = klass.getDeclaredMethod(methodName, paramTypes);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchMethodException e) {
            klass = klass.getSuperclass();
            if (klass == null) {
                return null;
            }
            return ReflectionUtils.getAvailableMethod(klass, methodName, new Class[0]);
        }
    }

    public static <R> R readField(Object object, String fieldName) throws NoSuchFieldException {
        return ReflectionUtils.readAvailableField(object.getClass(), object, fieldName);
    }

    public static <R> R readStaticField(Class<?> klass, String fieldName) throws NoSuchFieldException {
        return ReflectionUtils.readAvailableField(klass, null, fieldName);
    }

    private static <T, R> R readAvailableField(Class<? super T> klass, T object, String fieldName) throws NoSuchFieldException {
        Field field = ReflectionUtils.getAvailableField(klass, fieldName);
        if (field == null) {
            throw new NoSuchFieldException();
        }
        try {
            return (R)field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionAdapter.unchecked(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static <T> void writeField(Object object, String fieldName, Object value) throws NoSuchFieldException, IllegalFieldValue {
        ReflectionUtils.writeAvailableField(object.getClass(), object, fieldName, value);
    }

    public static void writeStaticField(Class<?> klass, String fieldName, Object value) throws NoSuchFieldException, IllegalFieldValue {
        ReflectionUtils.writeAvailableField(klass, null, fieldName, value);
    }

    private static <T> void writeAvailableField(Class<?> klass, T object, String fieldName, T value) throws NoSuchFieldException, IllegalFieldValue {
        Field field = ReflectionUtils.getAvailableField(klass, fieldName);
        if (field == null) {
            throw new NoSuchFieldException();
        }
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalFieldValue(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    private static Field getAvailableField(Class<?> klass, String fieldName) {
        try {
            return klass.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return ReflectionUtils.getDeclaredFieldInHierarchy(klass, fieldName);
        }
    }

    private static Field getDeclaredFieldInHierarchy(Class<?> klass, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            klass = klass.getSuperclass();
            if (klass == null) {
                return null;
            }
            return ReflectionUtils.getAvailableField(klass, fieldName);
        }
    }

    public static class IllegalFieldValue
    extends Exception {
        public IllegalFieldValue(String message) {
            super(Assert.AssertNamespace.assertNotNull(message));
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }
    }
}

