/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import melnorme.utilbox.core.ExceptionAdapter;
import melnorme.utilbox.misc.ByteArrayOutputStreamExt;
import melnorme.utilbox.misc.IByteSequence;

public class StreamUtil {
    public static final int EOF = -1;

    private static IOException createFailedToReadExpected(int length, int totalRead) {
        return new IOException("Failed to read requested amount of characters. Read: " + totalRead + " of total requested: " + length);
    }

    public static IByteSequence readAllBytesFromStream(InputStream inputStream) throws IOException {
        return StreamUtil.readAllBytesFromStream(inputStream, 32);
    }

    public static IByteSequence readAllBytesFromStream(InputStream inputStream, int capacity) throws IOException {
        try {
            int read;
            int BUFFER_SIZE = 1024;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStreamExt bytes = new ByteArrayOutputStreamExt(capacity);
            while ((read = inputStream.read(buffer)) != -1) {
                bytes.write(buffer, 0, read);
            }
            ByteArrayOutputStreamExt byteArrayOutputStreamExt = bytes;
            return byteArrayOutputStreamExt;
        }
        finally {
            inputStream.close();
        }
    }

    public static CharArrayWriter readAllCharsFromReader(Reader reader) throws IOException {
        try {
            int read;
            int BUFFER_SIZE = 1024;
            char[] buffer = new char[1024];
            CharArrayWriter chars = new CharArrayWriter();
            while ((read = reader.read(buffer)) != -1) {
                chars.write(buffer, 0, read);
            }
            CharArrayWriter charArrayWriter = chars;
            return charArrayWriter;
        }
        finally {
            reader.close();
        }
    }

    public static String readStringFromReader(Reader reader) throws IOException {
        return StreamUtil.readAllCharsFromReader(reader).toString();
    }

    public static char[] readRequiredAmountFromReader(Reader reader, int length) throws IOException {
        char[] chars = StreamUtil.readCharAmountFromReader(reader, length);
        if (chars.length != length) {
            throw StreamUtil.createFailedToReadExpected(length, chars.length);
        }
        return chars;
    }

    public static char[] readCharAmountFromReader(Reader reader, int length) throws IOException {
        try {
            int read;
            char[] chars = new char[length];
            int totalRead = 0;
            while ((read = reader.read(chars, totalRead, length - totalRead)) != -1 && (totalRead += read) != length) {
            }
            char[] cArray = chars;
            return cArray;
        }
        finally {
            reader.close();
        }
    }

    public static void writeBytesToStream(byte[] bytes, OutputStream outputStream) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(outputStream);){
            bos.write(bytes);
        }
    }

    public static void writeCharsToWriter(char[] chars, Writer writer) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(writer);){
            bw.write(chars);
        }
    }

    public static void writeStringToWriter(String string, Writer writer) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(writer);){
            bw.write(string);
        }
    }

    public static void writeStringToStream(String string, OutputStream stream, Charset charset) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, charset);){
            osw.append(string);
            osw.flush();
        }
    }

    public static void copyBytesToStream(InputStream inputStream, OutputStream outputStream, int length) throws IOException {
        int read;
        int BUFFER_SIZE = 1024;
        byte[] buffer = new byte[1024];
        int totalRead = 0;
        do {
            int readReqLen;
            if ((read = inputStream.read(buffer, 0, readReqLen = length == -1 ? 1024 : Math.min(1024, length - totalRead))) == -1) {
                if (length != -1) {
                    throw StreamUtil.createFailedToReadExpected(length, totalRead);
                }
                return;
            }
            outputStream.write(buffer, 0, read);
        } while ((totalRead += read) != length);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.copyStream(inputStream, outputStream, true);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, boolean closeOut) throws IOException {
        try {
            StreamUtil.copyBytesToStream(inputStream, outputStream, -1);
        }
        finally {
            try {
                inputStream.close();
            }
            finally {
                if (closeOut) {
                    outputStream.close();
                }
            }
        }
    }

    public static void uncheckedClose(InputStream inStream, boolean rethrowAsUnchecked) {
        block2: {
            try {
                inStream.close();
            }
            catch (IOException e) {
                if (!rethrowAsUnchecked) break block2;
                throw ExceptionAdapter.unchecked(e);
            }
        }
    }

    public static void uncheckedClose(Reader reader, boolean rethrowAsUnchecked) {
        block2: {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (!rethrowAsUnchecked) break block2;
                throw ExceptionAdapter.unchecked(e);
            }
        }
    }
}

