/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;

public class StringUtil {
    public static final Charset ASCII = Charset.forName("ASCII");
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");

    public static String asString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String nullAsEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String nullAsEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String emptyAsNull(String string) {
        if (string != null && string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String toString(Iterable<?> iterable, String separator) {
        return StringUtil.toString(iterable, separator, null);
    }

    public static String collToString(Iterable<?> coll, String separator) {
        return StringUtil.iterToString(coll, separator, null);
    }

    public static <T> String iterToString(Iterable<T> iterable, String separator, Function<? super T, String> toStringFn) {
        return StringUtil.toString(iterable, separator, toStringFn);
    }

    public static <T> String toString(Iterable<T> iterable, String separator, Function<? super T, String> toStringFn) {
        return StringUtil.iteratorToString(iterable.iterator(), separator, toStringFn);
    }

    private static <T> String iteratorToString(Iterator<T> iter, String sep, Function<? super T, String> toStringFn) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            T element = iter.next();
            sb.append(toStringFn == null ? element.toString() : toStringFn.apply(element));
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    private static <T> String debug_collToString(Collection<T> coll) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T element : coll) {
            if (!first) {
                sb.append("\n");
            }
            first = false;
            String elementString = element == null ? "null" : element.toString();
            sb.append(elementString.replace("\n", "\u00b6"));
        }
        return sb.toString();
    }

    private static String debug_mapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.append("\n");
            }
            first = false;
            sb.append(entry.getKey());
            sb.append("\u25ba");
            Object element = entry.getValue();
            String elementString = element == null ? "null" : element.toString();
            sb.append(elementString.replace("\n", "\u00b6"));
        }
        return sb.toString();
    }

    public static String collToString(Object[] coll, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Object[] objectArray = coll;
        int n = coll.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (!first) {
                sb.append(sep);
            }
            first = false;
            sb.append(item.toString());
            ++n2;
        }
        return sb.toString();
    }

    public static String[] collToStringArray(List<?> coll) {
        if (coll == null) {
            return new String[0];
        }
        String[] strs = new String[coll.size()];
        Iterator<?> iter = coll.iterator();
        int i = 0;
        while (i < strs.length) {
            strs[i] = iter.next().toString();
            ++i;
        }
        return strs;
    }

    public static int occurrenceCount(String string, char character) {
        int count = 0;
        int fromIndex = 0;
        while ((fromIndex = string.indexOf(character, fromIndex)) != -1) {
            ++count;
            ++fromIndex;
        }
        return count;
    }

    public static String replaceStr(String str, int repOffset, int repLen, String repStr) {
        return String.valueOf(str.substring(0, repOffset)) + repStr + str.substring(repOffset + repLen, str.length());
    }

    public static String replaceAll(String string, String matchStr, String repStr) {
        StringBuilder sb = new StringBuilder();
        int startIx = 0;
        while (true) {
            int matchIx;
            if ((matchIx = string.indexOf(matchStr, startIx)) == -1) break;
            sb.append(string, startIx, matchIx);
            sb.append(repStr);
            startIx = matchIx + matchStr.length();
        }
        sb.append(string, startIx, string.length());
        return sb.toString();
    }

    public static boolean replace(StringBuilder strb, String str, String repStr) {
        int ix = strb.indexOf(str);
        if (ix != -1) {
            strb.replace(ix, ix + str.length(), repStr);
            return true;
        }
        return false;
    }

    public static String substringUntilMatch(String string, String match) {
        int index = string.indexOf(match);
        return index == -1 ? string : string.substring(0, index);
    }

    public static String segmentUntilMatch(String string, String match) {
        int index = string.indexOf(match);
        return index == -1 ? null : string.substring(0, index);
    }

    public static String substringAfterMatch(String string, String match) {
        int index = string.indexOf(match);
        return index == -1 ? string : string.substring(index + match.length());
    }

    public static String segmentAfterMatch(String string, String match) {
        int index = string.indexOf(match);
        return index == -1 ? null : string.substring(index + match.length());
    }

    public static String substringUntilLastMatch(String string, String match) {
        int index = string.lastIndexOf(match);
        return index == -1 ? string : string.substring(0, index);
    }

    public static String segmentUntilLastMatch(String string, String match) {
        int index = string.lastIndexOf(match);
        return index == -1 ? null : string.substring(0, index);
    }

    public static String substringAfterLastMatch(String string, String match) {
        int index = string.lastIndexOf(match);
        return index == -1 ? string : string.substring(index + match.length());
    }

    public static String segmentAfterLastMatch(String string, String match) {
        int index = string.lastIndexOf(match);
        return index == -1 ? null : string.substring(index + match.length());
    }

    public static String substringFromMatch(char match, String string) {
        int indexOf = string.indexOf(match);
        return indexOf == -1 ? "" : string.substring(indexOf);
    }

    public static String substringFromMatch(String match, String string) {
        int indexOf = string.indexOf(match);
        return indexOf == -1 ? "" : string.substring(indexOf);
    }

    public static String trimStart(String string, String startMatch) {
        return StringUtil.removeStart(startMatch, string);
    }

    public static String removeStart(String startMatch, String string) {
        if (string.startsWith(startMatch)) {
            return string.substring(startMatch.length());
        }
        return string;
    }

    public static String trimEnd(String string, String endMatch) {
        if (string.endsWith(endMatch)) {
            return string.substring(0, string.length() - endMatch.length());
        }
        return string;
    }

    @Deprecated
    public static String trimEnding(String string, String endMatch) {
        return StringUtil.trimEnd(string, endMatch);
    }

    public static String trimLeadingSpaces(String string) {
        int pos = 0;
        while (pos < string.length() && string.charAt(pos) == ' ') {
            ++pos;
        }
        return string.substring(pos);
    }

    public static String newSpaceFilledString(int length) {
        return StringUtil.newFilledString(length, ' ');
    }

    public static String newFilledString(int length, char ch) {
        char[] str = new char[length];
        Arrays.fill(str, ch);
        return new String(str);
    }

    public static String newFilledString(int length, String str) {
        StringBuffer sb = new StringBuffer(length * str.length());
        int i = 0;
        while (i < length) {
            sb = sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String[] splitString(String string, char delimiter) {
        int count = StringUtil.occurrenceCount(string, delimiter);
        String[] segments = new String[count + 1];
        int startIx = 0;
        int i = 0;
        while (i < count) {
            int endIx = string.indexOf(delimiter, startIx);
            segments[i] = string.substring(startIx, endIx);
            startIx = endIx + 1;
            ++i;
        }
        segments[count] = string.substring(startIx);
        return segments;
    }

    public static ArrayList2<String> splitToList(String string, String regex) {
        Assert.AssertNamespace.assertNotNull(string);
        return new ArrayList2<String>(string.split(regex));
    }

    public static String prefixStr(String prefix, String string) {
        return string == null ? "" : String.valueOf(prefix) + string;
    }

    public static String asString(String prefix, Object obj) {
        return obj == null ? "" : String.valueOf(prefix) + obj.toString();
    }

    public static String commonPrefix(String ... strings) {
        Assert.AssertNamespace.assertTrue(strings.length > 0);
        String firstString = strings[0];
        int ix = 0;
        boolean finished = false;
        while (!finished) {
            if (ix >= firstString.length()) break;
            char ch = firstString.charAt(ix);
            int othersIx = 1;
            while (othersIx < strings.length) {
                String string = strings[othersIx];
                if (ix >= string.length() || string.charAt(ix) != ch) {
                    finished = true;
                    break;
                }
                ++othersIx;
            }
            if (finished) break;
            ++ix;
        }
        return firstString.substring(0, ix);
    }
}

