/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeoutException;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.concurrency.RunnableFuture2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.Result;
import melnorme.utilbox.misc.ByteArrayOutputStreamExt;
import melnorme.utilbox.misc.IByteSequence;
import melnorme.utilbox.misc.StreamUtil;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.AbstractExternalProcessHelper;

public class ExternalProcessHelper
extends AbstractExternalProcessHelper {
    protected final ICancelMonitor cancelMonitor;
    protected ReadAllBytesTask mainReader;
    protected ReadAllBytesTask stderrReader;

    public ExternalProcessHelper(ProcessBuilder pb) throws IOException {
        this(pb.start(), !pb.redirectErrorStream(), true);
    }

    public ExternalProcessHelper(Process process, boolean readStdErr, boolean startReaders) {
        this(process, readStdErr, startReaders, null);
    }

    public ExternalProcessHelper(Process process, boolean readStdErr, boolean startReaders, ICancelMonitor cancelMonitor) {
        super(process, readStdErr, startReaders);
        this.cancelMonitor = cancelMonitor == null ? new ICancelMonitor.NullCancelMonitor() : cancelMonitor;
    }

    @Override
    protected boolean isCanceled() {
        return this.cancelMonitor.isCanceled();
    }

    @Override
    protected Runnable createMainReaderTask() {
        this.mainReader = new ReadAllBytesTask(this.process.getInputStream());
        return this.stderrReader.runnableFuture;
    }

    @Override
    protected Runnable createStdErrReaderTask() {
        this.stderrReader = new ReadAllBytesTask(this.process.getErrorStream());
        return this.stderrReader.runnableFuture;
    }

    protected CommonException createCommonException(String message, Throwable cause) {
        return new CommonException(message, cause);
    }

    public static Process startProcess(ProcessBuilder pb) throws CommonException {
        try {
            return pb.start();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg == null) {
                msg = "Could not start process: ";
            }
            throw new CommonException(msg, ioe);
        }
    }

    public void writeInput(String input) throws IOException {
        this.writeInput(input, StringUtil.UTF8);
    }

    public void writeInput(String input, Charset charset) throws IOException {
        if (input == null) {
            return;
        }
        OutputStream processInputStream = this.getProcess().getOutputStream();
        StreamUtil.writeStringToStream(input, processInputStream, charset);
    }

    public void writeInput_(String input) throws CommonException {
        this.writeInput_(input, StringUtil.UTF8);
    }

    public void writeInput_(String input, Charset charset) throws CommonException {
        try {
            this.writeInput(input, charset);
        }
        catch (IOException e) {
            throw this.createCommonException("Error writing to process input.", e);
        }
    }

    protected ByteArrayOutputStreamExt getStdOutBytes() {
        Assert.AssertNamespace.assertTrue(this.areReadersTerminated());
        return this.mainReader.byteArray;
    }

    protected ByteArrayOutputStreamExt getStdErrBytes2() {
        Assert.AssertNamespace.assertTrue(this.areReadersTerminated());
        if (this.readStdErr) {
            return this.stderrReader.byteArray;
        }
        return null;
    }

    public ExternalProcessResult awaitTerminationAndResult() throws InterruptedException, IOException {
        try {
            return this.awaitTerminationAndResult(-1);
        }
        catch (TimeoutException e) {
            throw Assert.AssertNamespace.assertFail();
        }
    }

    public ExternalProcessResult awaitTerminationAndResult(int timeoutMs) throws InterruptedException, TimeoutException, IOException {
        try {
            this.awaitTermination(timeoutMs);
            this.mainReader.asRunnableFuture().getResult();
            if (this.stderrReader != null) {
                this.stderrReader.asRunnableFuture().getResult();
            }
        }
        catch (Exception e) {
            this.process.destroy();
            throw e;
        }
        return new ExternalProcessResult(this.process.exitValue(), this.getStdOutBytes(), this.getStdErrBytes2());
    }

    public ExternalProcessResult awaitTerminationAndResult_ce() throws CommonException, OperationCancellation {
        return this.awaitTerminationAndResult_ce(-1);
    }

    public ExternalProcessResult awaitTerminationAndResult_ce(int timeout) throws CommonException, OperationCancellation {
        try {
            return this.awaitTerminationAndResult(timeout);
        }
        catch (IOException e) {
            throw this.createCommonException("Error reading process stream.", e);
        }
        catch (TimeoutException te) {
            throw new OperationCancellation();
        }
        catch (InterruptedException e) {
            throw new OperationCancellation();
        }
    }

    public class ExternalProcessResult {
        public final int exitValue;
        public final ByteArrayOutputStreamExt stdout;
        public final ByteArrayOutputStreamExt stderr;

        public ExternalProcessResult(int exitValue, ByteArrayOutputStreamExt stdout, ByteArrayOutputStreamExt stderr) {
            this.exitValue = exitValue;
            this.stdout = Assert.AssertNamespace.assertNotNull(stdout);
            this.stderr = stderr != null ? stderr : new ByteArrayOutputStreamExt();
        }

        public IByteSequence getStdOutBytes() {
            return this.stdout;
        }

        public IByteSequence getStdErrBytes() {
            return this.stderr;
        }
    }

    protected static class ReadAllBytesTask {
        protected final InputStream is;
        protected final ByteArrayOutputStreamExt byteArray = new ByteArrayOutputStreamExt(32);
        protected final RunnableFuture2.ResultRunnableFuture<ByteArrayOutputStreamExt, IOException> runnableFuture;

        public ReadAllBytesTask(InputStream is) {
            this.is = is;
            this.runnableFuture = RunnableFuture2.toResultRunnableFuture(this::doRun);
        }

        public RunnableFuture2<Result<ByteArrayOutputStreamExt, IOException>> asRunnableFuture() {
            return this.runnableFuture;
        }

        public ByteArrayOutputStreamExt doRun() throws IOException {
            try {
                int read;
                int BUFFER_SIZE = 1024;
                byte[] buffer = new byte[1024];
                while ((read = this.is.read(buffer)) != -1) {
                    this.byteArray.write(buffer, 0, read);
                    this.notifyReadChunk(buffer, 0, read);
                }
                ByteArrayOutputStreamExt byteArrayOutputStreamExt = this.byteArray;
                return byteArrayOutputStreamExt;
            }
            finally {
                this.is.close();
            }
        }

        protected void notifyReadChunk(byte[] buffer, int offset, int readCount) {
        }
    }
}

