/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.status;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.StatusLevel;

public enum Severity {
    INFO,
    WARNING,
    ERROR;


    public boolean isError() {
        return this == ERROR;
    }

    public boolean isHigherSeverity(Severity other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean isHigherOrEqualSeverity(Severity other) {
        return this.ordinal() >= other.ordinal();
    }

    public String getLabel() {
        switch (this) {
            case WARNING: {
                return "Warning";
            }
            case ERROR: {
                return "Error";
            }
            case INFO: {
                return "Info";
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static Severity fromString(String severityString) throws CommonException {
        if (severityString == null) {
            return null;
        }
        switch (severityString.toUpperCase()) {
            case "WARNING": {
                return WARNING;
            }
            case "ERROR": {
                return ERROR;
            }
            case "INFO": {
                return INFO;
            }
        }
        throw new CommonException("Invalid Severity string `" + severityString + "`.");
    }

    public StatusLevel toStatusLevel() {
        switch (this) {
            case INFO: {
                return StatusLevel.INFO;
            }
            case WARNING: {
                return StatusLevel.WARNING;
            }
            case ERROR: {
                return StatusLevel.ERROR;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }
}

