/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.status;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.Severity;

public enum StatusLevel {
    OK,
    INFO,
    WARNING,
    ERROR;


    public boolean isOkStatus() {
        return this == OK;
    }

    public Severity toSeverity() {
        switch (this) {
            case OK: 
            case INFO: {
                return Severity.INFO;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case ERROR: {
                return Severity.ERROR;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static StatusLevel fromString(String messageTypeString) throws CommonException {
        if (messageTypeString == null) {
            return null;
        }
        switch (messageTypeString.toLowerCase()) {
            case "warning": {
                return WARNING;
            }
            case "error": {
                return ERROR;
            }
            case "info": {
                return INFO;
            }
            case "ok": {
                return INFO;
            }
        }
        throw new CommonException("Invalid Status: " + messageTypeString);
    }
}

