/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.tests;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.DevelopmentCodeMarkers;
import melnorme.utilbox.core.fntypes.RunnableX;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.tests.CommonTest;

public class CommonTestExt
extends CommonTest {
    public static final Location IGNORE_PATH = PathUtil.DEFAULT_ROOT_LOC.resolve_fromValid("###NO_CHECK###");
    public static final String IGNORE_STR = "###NO_CHECK###";
    public static final Object[] IGNORE_ARR = new Object[0];
    public static final String[] IGNORE_ARR_STR = new String[0];

    protected static <V> void checkSetContains(Set<V> set, V expectedValue) {
        Assert.AssertNamespace.assertTrue(set.remove(expectedValue));
    }

    public static String findMatch(String input, String regex) {
        return CommonTestExt.findMatch(input, regex, 0);
    }

    public static String findMatch(String input, String regex, int resultGroup) {
        Matcher matcher = Pattern.compile(regex, 1).matcher(input);
        boolean hasFound = matcher.find();
        if (!hasFound) {
            return null;
        }
        return matcher.group(resultGroup);
    }

    public static void runMultipleTimes(int liteTimes, int fullTimes, RunnableX<Exception> trun) throws Exception {
        int times = DevelopmentCodeMarkers.TESTS_LITE_MODE ? liteTimes : fullTimes;
        int i = 0;
        while (i < times) {
            trun.run();
            ++i;
        }
    }

    public static interface Checker<T> {
        public void check(T var1);
    }

    public static abstract class CommonChecker {
        public void checkAreEqual(Object obj, Object expected) {
            if (expected == IGNORE_PATH || expected == CommonTestExt.IGNORE_STR) {
                return;
            }
            Assert.AssertNamespace.assertTrue(CoreUtil.areEqual(obj, expected));
        }

        public void checkAreEqualArray(Object[] obj, Object[] expected) {
            if (this.isIgnoreArray(expected)) {
                return;
            }
            Assert.AssertNamespace.assertTrue(CoreUtil.areEqualArrays(obj, expected));
        }

        protected boolean isIgnoreArray(Object[] expected) {
            return expected == IGNORE_ARR || expected == IGNORE_ARR_STR;
        }

        protected Object[] ignoreIfNull(Object[] expected) {
            return expected == null ? IGNORE_ARR : expected;
        }
    }
}

