/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.FileUtil;
import melnorme.utilbox.misc.Location;

public class TestsWorkingDir {
    protected static final String TEST_RESOURCES_WORKING_DIR_PROPERTY = "Melnorme.TestsWorkingDir";
    protected static String testsWorkingDir;

    public static void initWorkingDir(String workingDir) {
        Assert.AssertNamespace.assertTrue(workingDir != null);
        Assert.AssertNamespace.assertTrue(testsWorkingDir == null);
        testsWorkingDir = workingDir;
        System.out.println("====>> WORKING DIR: " + testsWorkingDir);
        File file = new File(testsWorkingDir);
        if (!file.exists()) {
            file.mkdir();
        }
        Assert.AssertNamespace.assertTrue(file.toPath().isAbsolute());
    }

    protected static void defaultWorkingDirInit() {
        if (testsWorkingDir != null) {
            return;
        }
        String property = System.getProperty(TEST_RESOURCES_WORKING_DIR_PROPERTY);
        if (property != null) {
            TestsWorkingDir.initWorkingDir(property);
        } else {
            TestsWorkingDir.initWorkingDir(String.valueOf(System.getProperty("java.io.tmpdir")) + "/_tests");
        }
    }

    public static Location getWorkingDir() {
        TestsWorkingDir.defaultWorkingDirInit();
        Assert.AssertNamespace.assertNotNull(testsWorkingDir);
        File file = new File(testsWorkingDir);
        Assert.AssertNamespace.assertTrue(file.exists() && file.isDirectory() && file.isAbsolute());
        return Location.create_fromValid(file.toPath());
    }

    public static File getWorkingDirFile() {
        return TestsWorkingDir.getWorkingDir().toFile();
    }

    public static Path getWorkingDirPath() {
        return TestsWorkingDir.getWorkingDir().getPath();
    }

    public static Location getWorkingDir(String relativePath) {
        return TestsWorkingDir.getWorkingDir().resolve_fromValid(relativePath);
    }

    public static void deleteDir(Location dir) throws IOException {
        Assert.AssertNamespace.assertTrue(dir.startsWith(TestsWorkingDir.getWorkingDir()));
        FileUtil.deleteDir(dir);
    }
}

