/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.tree;

import melnorme.utilbox.tree.IElement;
import melnorme.utilbox.tree.TreeVisitor;

public class TreeDepthFinder
extends TreeVisitor {
    public int depth = 0;
    public int maxdepth = 0;
    public int mindepth = Integer.MAX_VALUE;
    private boolean findmindepth = false;
    private boolean breakOnChildren = false;

    public static int findMaxDepth(IElement elem) {
        TreeDepthFinder tdr = new TreeDepthFinder();
        tdr.traverse(elem);
        return tdr.maxdepth;
    }

    public static int findMinLeafDepth(IElement elem) {
        TreeDepthFinder tdr = new TreeDepthFinder();
        tdr.traverse(elem);
        return tdr.maxdepth;
    }

    public static int findMaxDistance(IElement elem) {
        return TreeDepthFinder.findMaxDepth(elem) - 1;
    }

    public static int findMinLeafDistance(IElement elem) {
        return TreeDepthFinder.findMinLeafDepth(elem) - 1;
    }

    public static boolean isLeaf(IElement elem) {
        TreeDepthFinder tdr = new TreeDepthFinder();
        tdr.breakOnChildren = true;
        tdr.traverse(elem);
        return tdr.maxdepth == 1;
    }

    @Override
    public boolean enterNode(IElement element) {
        ++this.depth;
        if (this.breakOnChildren && this.depth == 2) {
            return false;
        }
        if (this.depth > this.maxdepth) {
            this.maxdepth = this.depth;
        }
        if (this.findmindepth && this.depth < this.mindepth && TreeDepthFinder.isLeaf(element)) {
            this.mindepth = this.depth;
        }
        return true;
    }

    @Override
    public void leaveNode(IElement element) {
        --this.depth;
    }
}

