/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.debug.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import melnorme.lang.ide.debug.core.LangAbsolutePathSourceContainer;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ProgramRelativePathSourceContainer;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupParticipant;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;

public class LangSourceLookupDirector
extends DsfSourceLookupDirector {
    protected DsfSession session;

    public LangSourceLookupDirector() {
        this(null);
    }

    public LangSourceLookupDirector(DsfSession session) {
        super(session);
        this.session = session;
    }

    public void initializeParticipants() {
        if (this.session != null) {
            this.addParticipants(new ISourceLookupParticipant[]{new DsfSourceLookupParticipantExtension(this.session)});
        }
    }

    public ISourcePathComputer getSourcePathComputer() {
        ISourcePathComputer sourcePathComputer = super.getSourcePathComputer();
        if (sourcePathComputer != null) {
            return sourcePathComputer;
        }
        return new ISourcePathComputer(){
            LangSourcePathComputer langSourcePathComputer;
            {
                this.langSourcePathComputer = new LangSourcePathComputer();
            }

            public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
                return this.langSourcePathComputer.computeSourceContainers(configuration, monitor);
            }

            public String getId() {
                return "com.googlecode.goclipse.debug.sourceLocator";
            }
        };
    }

    protected ISourceLookupDirector getSourceLookupDirector() {
        AbstractSourceLookupDirector commonSourceLookupDirector = new AbstractSourceLookupDirector(){

            public void initializeParticipants() {
            }
        };
        ArrayList2 containers = new ArrayList2();
        containers.add((Object)new LangAbsolutePathSourceContainer());
        containers.add((Object)new ProgramRelativePathSourceContainer());
        this.customizeDefaultSourceContainers((ArrayList2<ISourceContainer>)containers);
        commonSourceLookupDirector.setSourceContainers((ISourceContainer[])containers.toArray(ISourceContainer.class));
        return commonSourceLookupDirector;
    }

    protected void customizeDefaultSourceContainers(ArrayList2<ISourceContainer> containers) {
    }

    protected static class DsfSourceLookupParticipantExtension
    extends DsfSourceLookupParticipant {
        protected static final Pattern CYGDRIVE_PATTERN = Pattern.compile("/cygdrive/([a-zA-Z])/(.*)");

        protected DsfSourceLookupParticipantExtension(DsfSession session) {
            super(session);
        }

        public String getSourceName(Object object) throws CoreException {
            Matcher matcher;
            String sourceName = super.getSourceName(object);
            if (sourceName != null & MiscUtil.OS_IS_WINDOWS && (matcher = CYGDRIVE_PATTERN.matcher(sourceName)).matches()) {
                sourceName = String.valueOf(matcher.group(1)) + ":/" + matcher.group(2);
            }
            return sourceName;
        }
    }

    public class LangSourcePathComputer
    implements ISourcePathComputerDelegate {
        public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
            ISourceContainer[] common = LangSourceLookupDirector.this.getSourceLookupDirector().getSourceContainers();
            ISourceContainer[] containers = new ISourceContainer[common.length];
            int i = 0;
            while (i < common.length) {
                Object container = common[i];
                ISourceContainerType type = container.getType();
                container = container instanceof AbsolutePathSourceContainer ? new LangAbsolutePathSourceContainer() : type.createSourceContainer(type.getMemento(container));
                containers[i] = container;
                ++i;
            }
            return containers;
        }
    }
}

