/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.debug.ui;

import java.lang.reflect.Method;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.LangImages;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.ReflectionUtils;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointType;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class CBreakpointLabelAdapter
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof ICBreakpoint && adapterType == ILabelProvider.class) {
            return (T)((Object)new BreakpointLabelProvider());
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return (Class[])CoreUtil.array((Object[])new Class[]{ILabelProvider.class});
    }

    public static class BreakpointLabelProvider
    extends CDebugModelPresentation {
        protected static Method computeOverlaysMethod;

        static {
            try {
                computeOverlaysMethod = CDebugModelPresentation.class.getDeclaredMethod("computeOverlays", ICBreakpoint.class);
                computeOverlaysMethod.setAccessible(true);
            }
            catch (Exception e) {
                computeOverlaysMethod = null;
            }
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)element);
            }
            return null;
        }

        protected Image getBreakpointImage(ICBreakpoint breakpoint) {
            try {
                if (breakpoint instanceof ICTracepoint) {
                    return this.getTracepointImage((ICTracepoint)breakpoint);
                }
                if (breakpoint instanceof ICDynamicPrintf) {
                    return this.getDynamicPrintfImage((ICDynamicPrintf)breakpoint);
                }
                if (breakpoint instanceof ICLineBreakpoint) {
                    ICBreakpointType breakpointType;
                    if (breakpoint instanceof ICBreakpointType && ((breakpointType = (ICBreakpointType)breakpoint).getType() & 2) != 0) {
                        return this.getHWBreakpointImage((ICLineBreakpoint)breakpoint);
                    }
                    return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
                }
                if (breakpoint instanceof ICWatchpoint) {
                    return this.getWatchpointImage((ICWatchpoint)breakpoint);
                }
                if (breakpoint instanceof ICEventBreakpoint) {
                    return this.getEventBreakpointImage((ICEventBreakpoint)breakpoint);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return null;
        }

        protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
            ImageDescriptor descriptor = null;
            descriptor = breakpoint.isEnabled() ? LangImages.BREAKPOINT_ENABLED : LangImages.BREAKPOINT_DISABLED;
            if (computeOverlaysMethod == null) {
                return null;
            }
            try {
                ImageDescriptor[] computeOverlays = (ImageDescriptor[])ReflectionUtils.uncheckedInvoke((Object)((Object)this), (Method)computeOverlaysMethod, (Object[])new Object[]{breakpoint});
                OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), computeOverlays);
                return LangImages.getManagedImage((ImageDescriptor)imageDescriptor);
            }
            catch (RuntimeException e) {
                LangCore.logError((String)"Error using reflection to bypass CDT private API. ", (Throwable)e);
                return null;
            }
        }
    }
}

