/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.internal.corext.template.java;

import _org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import melnorme.lang.ide.core.ISourceFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;

public class JavaContext
extends CompilationUnitContext {
    public JavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceFile compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public JavaContext(TemplateContextType type, IDocument document, Position completionPosition, ISourceFile compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    public boolean canEvaluate(Template template) {
        if (!this.hasCompatibleContextType(template)) {
            return false;
        }
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return (key.length() > 0 || !this.isAfterDot()) && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    private boolean isAfterDot() {
        try {
            IDocument document = this.getDocument();
            int offset = this.getCompletionOffset();
            return document.get(offset - 1, 1).charAt(0) == '.';
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private boolean hasCompatibleContextType(Template template) {
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException e) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException e) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException e) {
            return super.getKey();
        }
    }
}

