/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.internal.corext.template.java;

import _org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import _org.eclipse.jdt.internal.corext.template.java.ExclusivePositionUpdater;
import _org.eclipse.jdt.internal.corext.template.java.JavaDocContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import melnorme.lang.ide.core.text.LangDocumentPartitionerSetup;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JavaFormatter {
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private final String fLineDelimiter;

    public JavaFormatter(String lineDelimiter) {
        this.fLineDelimiter = lineDelimiter;
    }

    public void format(TemplateBuffer buffer, CompilationUnitContext context) throws BadLocationException {
        try {
            VariableTracker tracker = new VariableTracker(buffer);
            IDocument document = tracker.getDocument();
            this.internalFormat(document, context);
            this.convertLineDelimiters(document);
            if (!(context instanceof JavaDocContext) && !this.isReplacedAreaEmpty((TemplateContext)context)) {
                this.trimStart(document);
            }
            tracker.updateBuffer();
        }
        catch (MalformedTreeException e) {
            throw new BadLocationException();
        }
    }

    private void internalFormat(IDocument document, CompilationUnitContext context) throws BadLocationException {
        this.indent(document);
    }

    private void convertLineDelimiters(IDocument document) throws BadLocationException {
        int lines = document.getNumberOfLines();
        int line = 0;
        while (line < lines) {
            IRegion region = document.getLineInformation(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null) {
                document.replace(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            }
            ++line;
        }
    }

    protected void trimStart(IDocument document) throws BadLocationException {
        int i = 0;
        while (i != document.getLength() && Character.isWhitespace(document.getChar(i))) {
            ++i;
        }
        document.replace(0, i, "");
    }

    protected boolean isReplacedAreaEmpty(TemplateContext context) {
        DocumentTemplateContext dtc;
        if (context instanceof DocumentTemplateContext && (dtc = (DocumentTemplateContext)context).getStart() == dtc.getCompletionOffset()) {
            IDocument document;
            block5: {
                try {
                    document = dtc.getDocument();
                    int lineOffset = document.getLineInformationOfOffset(dtc.getStart()).getOffset();
                    if (lineOffset == dtc.getStart()) break block5;
                    return false;
                }
                catch (BadLocationException x) {
                    return true;
                }
            }
            if (document.get(dtc.getStart(), dtc.getEnd() - dtc.getStart()).trim().length() == 0) {
                return true;
            }
        }
        return false;
    }

    protected void indent(IDocument document) throws BadLocationException, MalformedTreeException {
    }

    private static class VariableTracker {
        private static final String CATEGORY = "__template_variables";
        private Document fDocument;
        private final TemplateBuffer fBuffer;
        private List<TypedPosition> fPositions;

        public VariableTracker(TemplateBuffer buffer) throws MalformedTreeException, BadLocationException {
            Assert.isLegal((buffer != null ? 1 : 0) != 0);
            this.fBuffer = buffer;
            this.fDocument = new Document(this.fBuffer.getString());
            VariableTracker.installJavaStuff(this.fDocument);
            this.fDocument.addPositionCategory(CATEGORY);
            this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
            this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
        }

        private static void installJavaStuff(Document document) {
            LangDocumentPartitionerSetup.getInstance().setup((IDocument)document);
        }

        public IDocument getDocument() {
            this.checkState();
            return this.fDocument;
        }

        private void checkState() {
            if (this.fDocument == null) {
                throw new IllegalStateException();
            }
        }

        public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
            this.checkState();
            TemplateVariable[] variables = this.fBuffer.getVariables();
            try {
                this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, variables);
            }
            catch (BadPositionCategoryException x) {
                Assert.isTrue((boolean)false);
            }
            this.fBuffer.setContent(this.fDocument.get(), variables);
            this.fDocument = null;
            return this.fBuffer;
        }

        private List<TypedPosition> createRangeMarkers(TemplateVariable[] variables, IDocument document) throws MalformedTreeException, BadLocationException {
            HashMap<ReplaceEdit, String> markerToOriginal = new HashMap<ReplaceEdit, String>();
            MultiTextEdit root = new MultiTextEdit(0, document.getLength());
            ArrayList<Object> edits = new ArrayList<Object>();
            boolean hasModifications = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] nArray = variable.getOffsets();
                String value = variable.getDefaultValue();
                if (this.isWhitespaceVariable(value)) {
                    String placeholder = JavaFormatter.COMMENT_START + value + JavaFormatter.COMMENT_END;
                    int j = 0;
                    while (j != nArray.length) {
                        ReplaceEdit replace = new ReplaceEdit(nArray[j], value.length(), placeholder);
                        root.addChild((TextEdit)replace);
                        hasModifications = true;
                        markerToOriginal.put(replace, value);
                        edits.add(replace);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j != nArray.length) {
                        RangeMarker marker = new RangeMarker(nArray[j], value.length());
                        root.addChild((TextEdit)marker);
                        edits.add(marker);
                        ++j;
                    }
                }
                ++i;
            }
            if (hasModifications) {
                root.apply(document, 2);
            }
            ArrayList<TypedPosition> positions = new ArrayList<TypedPosition>();
            for (TextEdit textEdit : edits) {
                try {
                    TypedPosition pos = new TypedPosition(textEdit.getOffset(), textEdit.getLength(), (String)markerToOriginal.get(textEdit));
                    document.addPosition(CATEGORY, (Position)pos);
                    positions.add(pos);
                }
                catch (BadPositionCategoryException x) {
                    Assert.isTrue((boolean)false);
                }
            }
            return positions;
        }

        protected boolean isWhitespaceVariable(String value) {
            int length = value.length();
            return length == 0 || Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1));
        }

        protected void removeRangeMarkers(List<TypedPosition> positions, IDocument document, TemplateVariable[] variables) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
            for (TypedPosition position : positions) {
                document.removePosition(CATEGORY, (Position)position);
                String original = position.getType();
                if (original != null) {
                    document.replace(position.getOffset(), position.getLength(), original);
                    position.setLength(original.length());
                }
                document.addPosition((Position)position);
            }
            Iterator<TypedPosition> it = positions.iterator();
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] offsets = new int[variable.getOffsets().length];
                int j = 0;
                while (j != offsets.length) {
                    offsets[j] = it.next().getOffset();
                    ++j;
                }
                variable.setOffsets(offsets);
                ++i;
            }
        }
    }
}

