/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.internal.ui.text.template.contentassist;

import _org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import _org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import melnorme.lang.ide.core.ISourceFile;
import melnorme.lang.ide.ui.LangElementImages;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.templates.LangTemplateProposal;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.CollectionUtil;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;

public class TemplateEngine {
    protected static final String $_LINE_SELECTION = "${line_selection}";
    protected static final String $_WORD_SELECTION = "${word_selection}";
    protected TemplateContextType fContextType;
    protected ArrayList2<TemplateProposal> fProposals = new ArrayList2();
    protected final Map<IDocument, Position> fPositions = new HashMap<IDocument, Position>();

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
        for (Map.Entry<IDocument, Position> entry : this.fPositions.entrySet()) {
            IDocument doc = entry.getKey();
            Position position = entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    public TemplateProposal[] getResults() {
        return (TemplateProposal[])this.fProposals.toArray((Object[])new TemplateProposal[this.fProposals.size()]);
    }

    public List<ICompletionProposal> completeAndReturnResults(SourceOpContext sourceOpContext, IDocument document) throws CommonException {
        this.complete(sourceOpContext, document);
        Object[] templateProposals = this.getResults();
        return CollectionUtil.createArrayList((Object[])templateProposals);
    }

    public void complete(SourceOpContext sourceOpContext, IDocument document) throws CommonException {
        final Location sourceFileLoc = sourceOpContext.getFileLocation();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        CompilationUnitContextType compilationUnitContextType = (CompilationUnitContextType)this.fContextType;
        SourceRange selection = sourceOpContext.getSelection();
        Position position = new Position(selection.getStartPos(), selection.getLength());
        String selectedText = null;
        if (selection.getLength() != 0) {
            try {
                selectedText = document.get(selection.getStartPos(), selection.getLength());
                document.addPosition(position);
                this.fPositions.put(document, position);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        ISourceFile compilationUnit = new ISourceFile(){

            public Location getLocation() {
                return sourceFileLoc;
            }
        };
        CompilationUnitContext context = compilationUnitContextType.createContext(document, position, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = this.getTemplates();
        if (selection.getLength() == 0) {
            Template[] templateArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                Template template = templateArray[n2];
                if (context.canEvaluate(template)) {
                    this.fProposals.add((Object)new LangTemplateProposal(template, (TemplateContext)context, (IRegion)region, this.getImage(), 0));
                }
                ++n2;
            }
        } else {
            if (context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            boolean multipleLinesSelected = this.areMultipleLinesSelected(document, selection);
            Template[] templateArray = templates;
            int n = templates.length;
            int n3 = 0;
            while (n3 < n) {
                Template template = templateArray[n3];
                if (context.canEvaluate(template) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add((Object)new LangTemplateProposal(template, (TemplateContext)context, (IRegion)region, this.getImage(), 0));
                }
                ++n3;
            }
        }
    }

    protected Template[] getTemplates() {
        return LangUIPlugin.getTemplateRegistry().getTemplateStore().getTemplates();
    }

    protected Image getImage() {
        return LangElementImages.CA_SNIPPET.getImage();
    }

    protected boolean areMultipleLinesSelected(IDocument document, SourceRange s) {
        if (s.getLength() == 0) {
            return false;
        }
        try {
            int startLine = document.getLineOfOffset(s.getOffset());
            int endLine = document.getLineOfOffset(s.getEndPos());
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.getOffset() == line.getOffset() && s.getLength() == line.getLength();
        }
        catch (BadLocationException x) {
            return false;
        }
    }
}

