/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.ui;

import _org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.util.swt.jface.resources.ImageDescriptorRegistry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList<ILabelProviderListener> fListeners;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : LangUIPlugin.getDefault().getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        if (image == null) {
            return null;
        }
        ImageDescriptor overlayImage = this.computeAdornmentFlags(obj);
        if (overlayImage != null) {
            return this.getRegistry().get((ImageDescriptor)new DecorationOverlayIcon(image, overlayImage, 2));
        }
        return image;
    }

    protected ImageDescriptor computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 376) {
                return null;
            }
            EclipseCore.logStatus((CoreException)e);
        }
        return null;
    }

    protected ImageDescriptor getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return null;
        }
        int severity = 0;
        severity = res.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, depth);
        if (severity == 2) {
            return LangImages.DESC_OVR_ERROR;
        }
        if (severity == 1) {
            return LangImages.DESC_OVR_WARNING;
        }
        return null;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            LangUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                @Override
                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange, boolean calledFromDisplayThread) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            LangUIPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                LangUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor imageDescriptor = this.computeAdornmentFlags(element);
        if (imageDescriptor != null) {
            decoration.addOverlay(imageDescriptor);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

