/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.editor;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.core.tools.GocodeServerManager;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.gocode.GocodeCompletionOperation;
import com.googlecode.goclipse.tooling.gocode.GocodeOutputParser2;
import com.googlecode.goclipse.ui.GoUIPlugin;
import java.util.Optional;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.text.completion.LangCompletionProposalComputer;
import melnorme.lang.tooling.ToolCompletionProposal;
import melnorme.lang.tooling.common.ops.IProcessRunner;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.process.ExternalProcessHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GocodeCompletionProposalComputer
extends LangCompletionProposalComputer {
    @Override
    protected Indexable<ToolCompletionProposal> doComputeProposals(SourceOpContext sourceContext, ICancelMonitor cm) throws CommonException, OperationCancellation, OperationSoftFailure {
        Location fileLoc = sourceContext.getFileLocation();
        int offset = sourceContext.getOffset();
        GocodeServerManager gocodeServerManager = GoUIPlugin.prepareGocodeManager_inUI();
        IPath gocodePath = gocodeServerManager.getGocodePath();
        if (gocodePath == null) {
            throw new CommonException("Error: gocode path not provided.");
        }
        IProject project = ResourceUtils.getProjectFromMemberLocation((Optional)sourceContext.getOptionalFileLocation());
        GoEnvironment goEnvironment = GoProjectEnvironment.getGoEnvironment((IProject)project);
        GocodeCompletionOperation client = new GocodeCompletionOperation((IProcessRunner)this.getEngineToolRunner(), goEnvironment, gocodePath.toOSString(), cm);
        String source = sourceContext.getSource();
        ExternalProcessHelper.ExternalProcessResult processResult = client.execute(fileLoc.toPathString(), source, offset);
        GocodeOutputParser2 gocodeOutputParser = new GocodeOutputParser2(offset, source){

            protected void logWarning(String message) {
                LangCore.logWarning((String)message);
            }
        };
        return (Indexable)gocodeOutputParser.doParseResult(processResult);
    }
}

