/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.navigator;

import com.googlecode.goclipse.ui.launch.GoLaunchShortcut;
import melnorme.lang.ide.ui.navigator.BuildTargetsActionGroup;
import melnorme.lang.ide.ui.navigator.LangNavigatorActionProvider;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class GoNavigatorActionProvider
extends LangNavigatorActionProvider {
    protected NavigatorOpenAction navigatorOpenAction;

    @Override
    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite cvws = (ICommonViewerWorkbenchSite)viewSite;
            this.navigatorOpenAction = new NavigatorOpenAction(cvws.getPage(), cvws.getSelectionProvider());
        }
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.navigatorOpenAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.navigatorOpenAction);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.navigatorOpenAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.navigatorOpenAction);
        }
    }

    @Override
    protected BuildTargetsActionGroup createBuildTargetsActionGroup(IViewPart viewPart) {
        return new BuildTargetsActionGroup(viewPart){

            @Override
            protected GoLaunchShortcut createLaunchShortcut() {
                return new GoLaunchShortcut();
            }
        };
    }

    public static class NavigatorOpenAction
    extends Action {
        protected final IWorkbenchPage page;
        protected final ISelectionProvider selectionProvider;
        protected IFileStore fileStore;

        public NavigatorOpenAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
            this.page = page;
            this.selectionProvider = selectionProvider;
            this.setText("Open");
        }

        public boolean isEnabled() {
            ISelection selection = this.selectionProvider.getSelection();
            if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                return false;
            }
            StructuredSelection ss = (StructuredSelection)selection;
            if (ss.size() == 1 && ss.getFirstElement() instanceof IFileStore) {
                IFileStore fileStore = (IFileStore)ss.getFirstElement();
                if (!fileStore.fetchInfo().isDirectory()) {
                    this.fileStore = fileStore;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void run() {
            if (this.isEnabled()) {
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)this.page, (IFileStore)this.fileStore);
                }
                catch (PartInitException exception) {
                    UIOperationsStatusHandler.handleInternalError("Error Opening File", exception);
                }
            }
        }
    }
}

