/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.navigator;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.env.GoRoot;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import com.googlecode.goclipse.ui.GoUIPlugin;
import com.googlecode.goclipse.ui.navigator.elements.GoPathElement;
import com.googlecode.goclipse.ui.navigator.elements.GoPathEntryElement;
import com.googlecode.goclipse.ui.navigator.elements.GoRootElement;
import java.net.URI;
import java.nio.file.Path;
import melnorme.lang.ide.core.project_model.view.BundleErrorElement;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.navigator.AbstractNavigatorContentProvider;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;

public class GoNavigatorContentProvider
extends AbstractNavigatorContentProvider {
    protected final Object[] NO_CHILDREN = new Object[0];
    protected final IPropertyChangeListener propListener = pce -> this.updateViewer();

    public GoNavigatorContentProvider() {
        GoUIPlugin.getCorePrefStore().addPropertyChangeListener(this.propListener);
    }

    @Override
    public void dispose() {
        GoUIPlugin.getCorePrefStore().removePropertyChangeListener(this.propListener);
        super.dispose();
    }

    protected void updateViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GoNavigatorContentProvider.this.viewer != null) {
                    GoNavigatorContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    @Override
    protected AbstractNavigatorContentProvider.LangNavigatorSwitcher_HasChildren hasChildren_switcher() {
        return new AbstractNavigatorContentProvider.LangNavigatorSwitcher_HasChildren(){

            @Override
            public Boolean visitGoPathElement(GoPathElement goPathElement) {
                return true;
            }

            @Override
            public Boolean visitFileStoreElement(IFileStore fileStore) {
                if (GoNavigatorContentProvider.this.getChildren(fileStore).length > 0) {
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected AbstractNavigatorContentProvider.LangNavigatorSwitcher_GetChildren getChildren_switcher() {
        return new AbstractNavigatorContentProvider.LangNavigatorSwitcher_GetChildren(this){

            @Override
            public void addFirstProjectChildren(IProject project, ArrayList2<Object> projectChildren) {
                projectChildren.addElements(GoNavigatorContentProvider.this.getProjectGoPathChildren(project));
            }

            @Override
            public Object[] visitGoPathElement(GoPathElement goPathElement) {
                try {
                    IFileStore fileStore = EFS.getStore((URI)goPathElement.getDirectory().toURI());
                    return fileStore.childStores(0, null);
                }
                catch (CoreException exception) {
                    return GoNavigatorContentProvider.this.NO_CHILDREN;
                }
            }

            @Override
            public Object[] visitFileStoreElement(IFileStore fileStore) {
                try {
                    return fileStore.childStores(0, null);
                }
                catch (CoreException e) {
                    return GoNavigatorContentProvider.this.NO_CHILDREN;
                }
            }
        };
    }

    @Override
    protected void addBuildTargetsContainer(IProject project, ArrayList2<Object> projectChildren) {
        super.addBuildTargetsContainer(project, projectChildren);
    }

    @Override
    protected AbstractNavigatorContentProvider.LangNavigatorSwitcher_GetParent getParent_switcher() {
        return new AbstractNavigatorContentProvider.LangNavigatorSwitcher_GetParent(){

            @Override
            public Object visitGoPathElement(GoPathElement goPathElement) {
                return null;
            }

            @Override
            public Object visitFileStoreElement(IFileStore fileStore) {
                return fileStore.getParent();
            }
        };
    }

    protected Object[] getProjectGoPathChildren(IProject project) {
        Location projectLocation;
        Location goRootSource;
        GoEnvironment goEnvironment = GoProjectEnvironment.getGoEnvironment((IProject)project);
        GoRoot goRoot = goEnvironment.getGoRoot();
        try {
            goRootSource = goRoot.getSourceRootLocation();
            projectLocation = ResourceUtils.getLocation((IResource)project);
        }
        catch (CommonException e) {
            return this.NO_CHILDREN;
        }
        ArrayList2 buildpathChildren = new ArrayList2();
        buildpathChildren.add((Object)new GoRootElement(goRootSource.toFile()));
        GoPath goPath = goEnvironment.getGoPath();
        for (String goPathEntry : goPath.getGoPathEntries()) {
            Path goPathEntryPath;
            try {
                goPathEntryPath = MiscUtil.createPath((String)goPathEntry);
            }
            catch (CommonException e) {
                continue;
            }
            if (CoreUtil.areEqual((Object)goPathEntryPath, (Object)project.getLocation().toFile().toPath())) continue;
            boolean projectInsideThisGoPathEntry = false;
            buildpathChildren.add((Object)new GoPathEntryElement(goPathEntryPath, project, projectInsideThisGoPathEntry));
        }
        GoWorkspaceLocation goWorkspaceRoot = goPath.findGoPathEntry(projectLocation);
        if (goWorkspaceRoot == null) {
            buildpathChildren.add((Object)new BundleErrorElement((IResource)project, "Project is not contained in any GOPATH entry."));
        }
        return buildpathChildren.toArray();
    }
}

