/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.navigator;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class NavigatorLinkHelper
implements ILinkHelper {
    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        IEditorPart part;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        IEditorInput input = null;
        if (element instanceof IEditorInput) {
            input = (IEditorInput)element;
        } else if (element instanceof IFile) {
            input = new FileEditorInput((IFile)element);
        } else if (element instanceof IFileStore) {
            input = new FileStoreEditorInput((IFileStore)element);
        }
        if (input != null && (part = page.findEditor(input)) != null) {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    public IStructuredSelection findSelection(IEditorInput input) {
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        if (file != null) {
            return new StructuredSelection((Object)file);
        }
        IFileStore fileStore = (IFileStore)input.getAdapter(IFileStore.class);
        if (fileStore == null && input instanceof FileStoreEditorInput) {
            URI uri = ((FileStoreEditorInput)input).getURI();
            try {
                fileStore = EFS.getStore((URI)uri);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (fileStore != null) {
            return new StructuredSelection((Object)fileStore);
        }
        return StructuredSelection.EMPTY;
    }
}

