/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.wizards;

import com.googlecode.goclipse.ui.wizards.NewGoWizardPage;
import com.googlecode.goclipse.ui.wizards.NewSourceFileComposite;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import melnorme.lang.ide.core.LangCore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewGoFileWizard
extends Wizard
implements INewWizard {
    private NewGoWizardPage page;
    private ISelection selection;

    public NewGoFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewGoWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewGoFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        InputStream stream = this.openContentStream(file);
        if (file.exists()) {
            file.setContents(stream, true, true, monitor);
        } else {
            file.create(stream, true, monitor);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    LangCore.logError((String)"Error opening editor", (Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(IFile file) {
        NewSourceFileComposite.SourceFileType type = this.page.getSourFileType();
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case PACKAGE_FILE: {
                sb.append("package ").append(file.getParent().getName()).append("\n");
                sb.append("\n");
                sb.append("import (\n\n");
                sb.append(")\n\n");
                break;
            }
            case MAIN_DEFAULT: {
                sb.append("package main \n\n");
                sb.append("import (\n\n");
                sb.append(")\n\n");
                sb.append("func main() {\n\n");
                sb.append("}\n\n");
                break;
            }
            case MAIN_WITH_PARAMETERS: {
                sb.append("package main \n\n");
                sb.append("import (\n");
                sb.append("    \"flag\"\n");
                sb.append("    \"fmt\"\n");
                sb.append(")\n\n");
                sb.append("const APP_VERSION = \"0.1\"\n\n");
                sb.append("// The flag package provides a default help printer via -h switch\n");
                sb.append("var versionFlag *bool = flag.Bool(\"v\", false, \"Print the version number.\")\n\n");
                sb.append("func main() {\n");
                sb.append("    flag.Parse() // Scan the arguments list \n\n");
                sb.append("    if *versionFlag {\n");
                sb.append("        fmt.Println(\"Version:\", APP_VERSION)\n");
                sb.append("    }\n");
                sb.append("}\n\n");
                break;
            }
            case MAIN_WEBSERVER: {
                sb.append("package main \n\n");
                sb.append("import (\n");
                sb.append("    \"net/http\"\n");
                sb.append("    \"fmt\"\n");
                sb.append(")\n\n");
                sb.append("// Default Request Handler\n");
                sb.append("func defaultHandler(w http.ResponseWriter, r *http.Request) {\n");
                sb.append("    fmt.Fprintf(w, \"<h1>Hello %s!</h1>\", r.URL.Path[1:])\n");
                sb.append("}\n\n");
                sb.append("func main() {\n");
                sb.append("    http.HandleFunc(\"/\", defaultHandler)\n");
                sb.append("    http.ListenAndServe(\":8080\", nil)\n");
                sb.append("}\n\n");
                break;
            }
            case TEST: {
                sb.append("package ").append(file.getParent().getName()).append("\n");
                sb.append("\n");
                sb.append("import (\n");
                sb.append("    \"testing\"\n");
                sb.append(")\n\n");
                sb.append("func TestXYZ(t *testing.T) {\n\n");
                sb.append("}\n\n");
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "goclipse", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

