/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.wizards;

import com.googlecode.goclipse.ui.GoPluginImages;
import com.googlecode.goclipse.ui.wizards.DialogChangeListener;
import com.googlecode.goclipse.ui.wizards.NewSourceFileComposite;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewGoWizardPage
extends WizardPage
implements DialogChangeListener {
    private NewSourceFileComposite sourceFileComposite;
    private ISelection selection;

    public NewGoWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Go Source File");
        this.setDescription("This wizard creates a new source file.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.sourceFileComposite = new NewSourceFileComposite(container, 0);
        this.sourceFileComposite.addDialogChangedListener(this);
        GridData gd = new GridData(768);
        this.sourceFileComposite.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.setImageDescriptor(GoPluginImages.WIZARD_SOURCE_ICON.getDescriptor());
        String path = null;
        IPath prjPath = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                path = container.getFullPath().toString();
                prjPath = ((IResource)obj).getProject().getLocation();
            }
            if (path != null) {
                this.sourceFileComposite.getSourceFolderName().setText(path);
            }
        }
        String newFilePrefix = "new_file";
        String fName = "new_file.go";
        if (path != null && prjPath != null) {
            this.sourceFileComposite.getSourceFolderName().setText(path);
            String fullPath = prjPath.removeLastSegments(1).append(path).toOSString();
            File f = new File(fullPath);
            String[] newFiles = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String name) {
                    return name.startsWith("new_file") && name.endsWith(".go");
                }
            });
            if (newFiles != null && newFiles.length > 0) {
                int i = newFiles.length + 1;
                while (true) {
                    fName = "new_file_" + i + ".go";
                    File nf = new File(String.valueOf(fullPath) + File.separator + fName);
                    if (!nf.exists()) break;
                    ++i;
                }
            }
        }
        int pos = fName.indexOf(".go");
        this.sourceFileComposite.getSourceFilename().setText(fName);
        this.sourceFileComposite.getSourceFilename().setSelection(0, pos);
        this.sourceFileComposite.getSourceFilename().forceFocus();
    }

    @Override
    public void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(String.valueOf(this.getContainerName()) + "/" + fileName));
        if (file != null) {
            this.updateStatus("File " + fileName + " already exists. Choose a new name.");
            return;
        }
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("go")) {
            this.updateStatus("File extension must be \"go\"");
            return;
        }
        if (this.sourceFileComposite.getSourceFileType() == NewSourceFileComposite.SourceFileType.TEST && !this.sourceFileComposite.getSourceFilename().getText().endsWith("_test.go")) {
            this.updateStatus("Tests must end with \"_test.go\" suffix");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.sourceFileComposite.getSourceFolderName().getText();
    }

    public String getFileName() {
        return this.sourceFileComposite.getSourceFilename().getText();
    }

    public NewSourceFileComposite.SourceFileType getSourFileType() {
        return this.sourceFileComposite.getSourceFileType();
    }
}

