/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import _org.eclipse.debug.internal.ui.SWTFactory;
import java.util.Arrays;
import java.util.List;
import melnorme.lang.ide.ui.build.AbstractDebugSelectionDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

abstract class AbstractDebugCheckboxSelectionDialog
extends AbstractDebugSelectionDialog {
    private boolean fShowSelectButtons = false;

    public AbstractDebugCheckboxSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected CheckboxTableViewer getCheckBoxTableViewer() {
        return (CheckboxTableViewer)this.fViewer;
    }

    @Override
    protected void initializeControls() {
        List selectedElements = this.getInitialElementSelections();
        if (selectedElements != null && !selectedElements.isEmpty()) {
            this.getCheckBoxTableViewer().setCheckedElements(selectedElements.toArray());
            this.getCheckBoxTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        super.initializeControls();
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Table table = new Table(parent, 2084);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        return new CheckboxTableViewer(table);
    }

    @Override
    protected void addViewerListeners(StructuredViewer viewer) {
        this.getCheckBoxTableViewer().addCheckStateListener((ICheckStateListener)new DefaultCheckboxListener());
    }

    @Override
    protected boolean isValid() {
        return this.getCheckBoxTableViewer().getCheckedElements().length > 0;
    }

    protected void okPressed() {
        Object[] elements = this.getCheckBoxTableViewer().getCheckedElements();
        this.setResult(Arrays.asList(elements));
        super.okPressed();
    }

    @Override
    protected void addCustomFooterControls(Composite parent) {
        if (this.fShowSelectButtons) {
            Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
            GridData gd = (GridData)comp.getLayoutData();
            gd.horizontalAlignment = 0x1000008;
            Button button = SWTFactory.createPushButton(comp, "&Select All", null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractDebugCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(true);
                    AbstractDebugCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractDebugCheckboxSelectionDialog.this.isValid());
                }
            });
            button = SWTFactory.createPushButton(comp, "&Deselect All", null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractDebugCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(false);
                    AbstractDebugCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractDebugCheckboxSelectionDialog.this.isValid());
                }
            });
        }
    }

    protected void setShowSelectAllButtons(boolean setting) {
        this.fShowSelectButtons = setting;
    }

    private class DefaultCheckboxListener
    implements ICheckStateListener {
        private DefaultCheckboxListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            AbstractDebugCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractDebugCheckboxSelectionDialog.this.isValid());
        }
    }
}

