/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.dialogs;

import melnorme.lang.ide.ui.utils.DialogPageUtils;
import melnorme.lang.ide.ui.utils.operations.UIOperation;
import melnorme.lang.ide.ui.utils.operations.WorkbenchOperationExecutor;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.IValidatableWidget;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.IStatusMessage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractLangPropertyPage2<WIDGET extends IValidatableWidget>
extends PropertyPage {
    protected WIDGET preferencesWidget;

    protected IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return (IProject)adaptable.getAdapter(IProject.class);
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.preferencesWidget = this.createProjectConfigWidget(this.getProject());
    }

    public WIDGET getPreferencesWidget() {
        return this.preferencesWidget;
    }

    protected abstract WIDGET createProjectConfigWidget(IProject var1);

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        if (project == null) {
            return SWTFactoryUtil.createLabel(parent, 16384, "No project available", null);
        }
        return this.doCreateContents(parent, project);
    }

    protected Control doCreateContents(Composite parent, IProject project) {
        Composite component = this.preferencesWidget.createComponent(parent);
        this.preferencesWidget.getStatusField().registerListener(true, __ -> this.updateStatusMessage());
        return component;
    }

    protected void updateStatusMessage() {
        DialogPageUtils.setPrefPageStatus((PreferencePage)this, (IStatusMessage)this.preferencesWidget.getStatusField().get());
    }

    public final boolean performOk() {
        UIOperation op = new UIOperation("Saving project settings", this::doPerformSave){

            @Override
            protected WorkbenchOperationExecutor getBackgroundOperationExecutor() {
                return new WorkbenchOperationExecutor.ProgressMonitorDialogOpRunner(AbstractLangPropertyPage2.this.getShell());
            }
        };
        return op.executeAndHandle();
    }

    public abstract void doPerformSave(IOperationMonitor var1) throws CommonException, OperationCancellation;

    protected abstract void performDefaults();
}

