/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.dialogs;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.dialogs.LangProjectWizardFirstPage;
import melnorme.lang.ide.ui.dialogs.ProjectCreationOperation;
import melnorme.lang.ide.ui.dialogs.WizardMessages;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class LangNewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension,
IPageChangingListener {
    public static final String WIZARD_ID = String.valueOf(LangUIPlugin.PLUGIN_ID) + ".wizards.NewProjectWizard";
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected IConfigurationElement fConfigElement;
    private ProjectCreationOperation projectCreationOperation;

    public LangNewProjectWizard() {
        this.setWindowTitle(WizardMessages.LangNewProject_wizardTitle);
        this.setDialogSettings(LangUIPlugin.getInstance().getDialogSettings());
        this.setNeedsProgressMonitor(true);
    }

    public abstract LangProjectWizardFirstPage getFirstPage();

    public abstract WizardPage getSecondPage();

    public IProject getProject() throws CoreException {
        try {
            return this.getFirstPage().getProjectHandle2();
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException((CommonException)ce);
        }
    }

    public IPath getProjectLocation2() {
        return this.getFirstPage().getProjectLocation();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        if (selection != null && selection.getFirstElement() instanceof IProject) {
            IProject selectedProject = (IProject)selection.getFirstElement();
            this.getFirstPage().getNameGroup().getNameField().setFieldValue(selectedProject.getName());
        }
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
    }

    public void addPages() {
        super.addPages();
    }

    public void handlePageChanging(PageChangingEvent event) {
        Object currentPage = event.getCurrentPage();
        Object nextPage = event.getTargetPage();
        if (currentPage == this.getFirstPage() && nextPage == this.getSecondPage()) {
            event.doit = this.changeToNewProject();
        } else if (currentPage == this.getSecondPage() && nextPage == this.getFirstPage()) {
            this.removeProject();
        }
    }

    protected boolean changeToNewProject() {
        return this.getProjectCreator().performCreateProject();
    }

    public void removeProject() {
        this.getProjectCreator().revertProjectCreation();
    }

    public ProjectCreationOperation getProjectCreator() {
        if (this.projectCreationOperation == null) {
            this.projectCreationOperation = this.createProjectCreator();
        }
        return this.projectCreationOperation;
    }

    protected ProjectCreator_ForWizard createProjectCreator() {
        return new ProjectCreator_ForWizard();
    }

    protected abstract void configureCreatedProject(ProjectCreator_ForWizard var1, IProgressMonitor var2) throws OperationCancellation, CommonException, CoreException;

    public boolean performFinish() {
        ProjectCreationOperation projectCreator = this.getProjectCreator();
        boolean success = projectCreator.performCreateProject();
        if (success) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)projectCreator.getCreatedProject());
            projectCreator.performFinishActions();
        }
        return success;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    public boolean performCancel() {
        return this.getProjectCreator().revertProjectCreation();
    }

    protected void openEditorOnFile(IFile file) {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (PartInitException e) {
            LangCore.logInternalError((Throwable)e);
        }
    }

    protected class ProjectCreator_ForWizard
    extends ProjectCreationOperation {
        public ProjectCreator_ForWizard() {
            super((IRunnableContext)LangNewProjectWizard.this.getContainer());
        }

        @Override
        public IProject getProject() throws CoreException {
            return LangNewProjectWizard.this.getProject();
        }

        @Override
        public IPath getProjectLocation2() {
            return LangNewProjectWizard.this.getProjectLocation2();
        }

        @Override
        protected void configureCreatedProject(IProgressMonitor monitor) throws CoreException, CommonException, OperationCancellation {
            LangNewProjectWizard.this.configureCreatedProject(this, monitor);
        }

        public void createFolder(IContainer container, IProgressMonitor monitor) throws CoreException {
            if (container.exists() || !(container instanceof IFolder)) {
                return;
            }
            this.createFolder(container.getParent(), monitor);
            final IFolder folder = (IFolder)container;
            ResourceUtils.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
            this.revertActions.add((Object)new ProjectCreationOperation.IRevertAction(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    if (folder.members().length == 0) {
                        folder.delete(false, monitor);
                    }
                }
            });
        }

        public void createFile(final IFile file, String contents, boolean openEditor, IProgressMonitor monitor) throws CoreException {
            Assert.AssertNamespace.assertNotNull((Object)contents);
            if (file.exists()) {
                return;
            }
            this.createFolder(file.getParent(), monitor);
            ResourceUtils.writeStringToFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
            final Runnable openEditorRunnable = new Runnable(){

                @Override
                public void run() {
                    LangNewProjectWizard.this.selectAndReveal((IResource)file);
                    LangNewProjectWizard.this.openEditorOnFile(file);
                }
            };
            this.revertActions.add((Object)new ProjectCreationOperation.IRevertAction(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    ProjectCreator_ForWizard.this.finishActions.remove((Object)openEditorRunnable);
                    file.delete(false, monitor);
                }
            });
            if (openEditor) {
                this.finishActions.add((Object)openEditorRunnable);
            }
        }
    }
}

