/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;

public abstract class ProjectCreationOperation {
    protected final IRunnableContext context;
    protected final ArrayList2<IRevertAction> revertActions = new ArrayList2();
    protected final ArrayList2<Runnable> finishActions = new ArrayList2();
    protected IProject createdProject;

    public ProjectCreationOperation(IRunnableContext context) {
        this.context = context;
    }

    protected IRunnableContext getRunnableContext() {
        return this.context;
    }

    public IProject getCreatedProject() {
        return this.createdProject;
    }

    public abstract IProject getProject() throws CoreException;

    public abstract IPath getProjectLocation2();

    protected boolean runOperation(boolean isCancellabe, String errorTitle, ResourceUtils.CoreOperation operation) {
        try {
            ResourceUtils.runOperationInWorkspace((IRunnableContext)this.getRunnableContext(), (boolean)isCancellabe, (Operation)operation);
            return true;
        }
        catch (OperationCancellation e) {
            return false;
        }
        catch (CommonException e) {
            UIOperationsStatusHandler.handleStatus(true, errorTitle, e);
            return false;
        }
    }

    public boolean performCreateProject() {
        boolean success = this.runOperation(true, "Error creating project.", this::doCreateProject);
        if (!success) {
            this.revertProjectCreation();
        }
        return success;
    }

    protected void doCreateProject(IProgressMonitor monitor) throws CoreException, CommonException, OperationCancellation {
        this.createdProject = null;
        if (this.getProject() == null) {
            throw new CommonException("No project name specified.");
        }
        if (!this.getProject().exists()) {
            String projectName = this.getProject().getName();
            ResourceUtils.createAndOpenProject((String)projectName, (IPath)this.getProjectLocation2(), (boolean)false, (IProgressMonitor)monitor);
            this.revertActions.add((Object)new IRevertAction(){

                @Override
                public void run(IProgressMonitor pm) throws CoreException {
                    ProjectCreationOperation.this.getProject().delete(true, pm);
                }
            });
        }
        if (!this.getProject().hasNature("com.googlecode.goclipse.core.goNature")) {
            EclipseUtils.addNature((IProject)this.getProject(), (String)"com.googlecode.goclipse.core.goNature");
            this.revertActions.add((Object)new IRevertAction(){

                @Override
                public void run(IProgressMonitor pm) throws CoreException {
                    EclipseUtils.removeNature((IProject)ProjectCreationOperation.this.getProject(), (String)"com.googlecode.goclipse.core.goNature");
                }
            });
        }
        this.createdProject = this.getProject();
        this.configureCreatedProject(monitor);
        ResourceUtils.refresh((IResource)this.getProject(), (IOperationMonitor)EclipseUtils.om((IProgressMonitor)monitor));
    }

    protected abstract void configureCreatedProject(IProgressMonitor var1) throws CommonException, OperationCancellation, CoreException;

    public boolean revertProjectCreation() {
        return this.runOperation(true, "Error removing temporary project.", this::doRevertProjectCreation);
    }

    protected void doRevertProjectCreation(IProgressMonitor monitor) throws CoreException {
        ArrayList<IRevertAction> revertActionsToRun = new ArrayList<IRevertAction>((Collection<IRevertAction>)this.revertActions);
        this.revertActions.clear();
        Collections.reverse(revertActionsToRun);
        for (IRevertAction revertAction : revertActionsToRun) {
            revertAction.run(monitor);
        }
    }

    public void performFinishActions() {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        for (Runnable runnable : this.finishActions) {
            runnable.run();
        }
        this.finishActions.clear();
    }

    public static interface IRevertAction {
        public void run(IProgressMonitor var1) throws CoreException;
    }
}

