/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import com.googlecode.goclipse.ui.editor.actions.GoFmtEditorOperation;
import java.util.ArrayList;
import java.util.List;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.TextSettings_Actual;
import melnorme.lang.ide.core.operations.ToolchainPreferences;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.prefs.EclipsePreferencesAdapter;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.LangUIPlugin_Actual;
import melnorme.lang.ide.ui.editor.EditorTitleImageUpdater;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.ISourceViewerExt;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.editor.TextEditorExt;
import melnorme.lang.ide.ui.editor.actions.GotoMatchingBracketManager;
import melnorme.lang.ide.ui.editor.text.LangPairMatcher;
import melnorme.lang.ide.ui.text.AbstractLangSourceViewerConfiguration;
import melnorme.lang.ide.ui.utils.PluginImagesHelper;
import melnorme.lang.utils.EnablementCounter;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.ownership.Disposable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public abstract class AbstractLangEditor
extends TextEditorExt {
    protected final EditorTitleImageUpdater editorTitleImageUpdater = this.addOwned(new EditorTitleImageUpdater(this));
    protected final AbstractTextEditor.AbstractSelectionChangedListener editorSelChangedListener = new AbstractTextEditor.AbstractSelectionChangedListener((AbstractTextEditor)this){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractLangEditor.this.handleEditorSelectionChanged(event);
        }
    };
    protected final LangPairMatcher fBracketMatcher = this.addOwned(this.init_createBracketMatcher());
    protected final GotoMatchingBracketManager gotoMatchingBracketManager = this.init_createGoToMatchingBracketManager();
    protected final EnablementCounter saveActionsEnablement = new EnablementCounter();

    public AbstractLangEditor() {
        LangUIPlugin.startDebugPlugin();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.initialize_setContextMenuIds();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes((String[])CoreUtil.array((Object[])new String[]{EditorSettings_Actual.EDITOR_CONTEXT_ID}));
    }

    protected void initialize_setContextMenuIds() {
        this.setEditorContextMenuId("#GoEditorContext");
        this.setRulerContextMenuId("#GoEditorRulerContext");
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input == null) {
            LangCore.logError((String)"doSetInput = null");
            return;
        }
        LangSourceViewer sourceViewer = this.getSourceViewer_();
        if (sourceViewer == null) {
            this.changePreferenceStore(this.createCombinedPreferenceStore(input));
        } else {
            this.getSourceViewerDecorationSupport(sourceViewer).uninstall();
            sourceViewer.unconfigure();
            this.changePreferenceStore(this.createCombinedPreferenceStore(input));
            sourceViewer.configure(this.getSourceViewerConfiguration());
            this.getSourceViewerDecorationSupport(sourceViewer).install(this.getPreferenceStore());
        }
        IDocument doc = this.getDocumentProvider().getDocument((Object)input);
        TextSettings_Actual.createDocumentSetupHelper().setupPartitioningIfNotSet(doc);
        this.internalDoSetInput(input);
    }

    protected void changePreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.createSourceViewerConfiguration());
    }

    protected abstract AbstractLangSourceViewerConfiguration createSourceViewerConfiguration();

    public AbstractLangSourceViewerConfiguration getSourceViewerConfiguration_asLang() {
        SourceViewerConfiguration svc = this.getSourceViewerConfiguration();
        if (svc instanceof AbstractLangSourceViewerConfiguration) {
            return (AbstractLangSourceViewerConfiguration)svc;
        }
        return null;
    }

    protected IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(4);
        IProject project = EditorUtils.getAssociatedProject(input);
        if (project != null) {
            stores.add((IPreferenceStore)new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project), LangUIPlugin.PLUGIN_ID));
        }
        stores.add(LangUIPlugin.getInstance().getPreferenceStore());
        stores.add(LangUIPlugin.getInstance().getCorePreferenceStore());
        this.alterCombinedPreferenceStores_beforeEditorsUI(stores);
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore((IPreferenceStore[])ArrayUtil.createFrom(stores, IPreferenceStore.class));
    }

    protected void alterCombinedPreferenceStores_beforeEditorsUI(List<IPreferenceStore> stores) {
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        AbstractLangSourceViewerConfiguration langSVC = this.getSourceViewerConfiguration_asLang();
        if (langSVC != null) {
            LangSourceViewer sourceViewer = this.getSourceViewer_();
            langSVC.handlePropertyChange(event, this.getPreferenceStore(), (SourceViewer)sourceViewer);
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event);
    }

    protected void internalDoSetInput(IEditorInput input) {
        Assert.AssertNamespace.assertNotNull((Object)input);
        this.editorTitleImageUpdater.updateEditorImage(EditorUtils.getAssociatedFile(input));
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        LangSourceViewer viewer = this.doCreateSourceViewer(parent, ruler, styles);
        CoreUtil.assertInstance((Object)viewer, SourceViewer.class);
        CoreUtil.assertInstance((Object)viewer, ISourceViewerExt.class);
        return viewer;
    }

    public LangSourceViewer getSourceViewer_() {
        return (LangSourceViewer)this.getSourceViewer();
    }

    public ISourceViewerExt getSourceViewer_asExt() {
        return (ISourceViewerExt)this.getSourceViewer();
    }

    protected LangSourceViewer doCreateSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        LangSourceViewer viewer = new LangSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport(viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.editorSelChangedListener.install(this.getSelectionProvider());
    }

    public PluginImagesHelper.ImageHandle getBaseEditorImage() {
        return LangImages.SOURCE_EDITOR_ICON;
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected void handleEditorSelectionChanged(SelectionChangedEvent event) {
    }

    protected abstract LangPairMatcher init_createBracketMatcher();

    protected GotoMatchingBracketManager init_createGoToMatchingBracketManager() {
        return new GotoMatchingBracketManager(this);
    }

    public final LangPairMatcher getBracketMatcher() {
        return this.fBracketMatcher;
    }

    public final GotoMatchingBracketManager getGotoMatchingBracketManager() {
        return this.gotoMatchingBracketManager;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.configureBracketMatcher(support);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void configureBracketMatcher(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(EditorSettings_Actual.EditorPrefConstants.MATCHING_BRACKETS_.key, EditorSettings_Actual.EditorPrefConstants.MATCHING_BRACKETS_COLOR2.getActiveKey(), "editor.highlightBracketAtCaretLocation", "editor.enclosingBrackets");
    }

    public EnablementCounter saveActionsEnablement() {
        return this.saveActionsEnablement;
    }

    public void saveWithoutSaveActions2(ICancelMonitor cm) {
        this.saveWithoutSaveActions(EclipseUtils.pm((ICancelMonitor)cm));
    }

    public void saveWithoutSaveActions(IProgressMonitor pm) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Disposable disposable = this.saveActionsEnablement().enterDisable();){
            this.doSave(pm);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void performSave(boolean overwrite, IProgressMonitor pm) {
        IProject associatedProject;
        if (this.saveActionsEnablement.isEnabled() && ((Boolean)ToolchainPreferences.FORMAT_ON_SAVE.getEffectiveValue(associatedProject = EditorUtils.getAssociatedProject(this.getEditorInput()))).booleanValue()) {
            GoFmtEditorOperation formatOperation = LangUIPlugin_Actual.getFormatOperation((ITextEditor)this);
            formatOperation.handleSoftFailureWithDialog = false;
            formatOperation.executeAndHandle();
        }
        super.performSave(overwrite, pm);
    }
}

