/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.utils.operations.WorkbenchOperationExecutor;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.concurrency.RunnableFuture2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.OperationCallable;
import melnorme.utilbox.core.fntypes.OperationResult;
import melnorme.utilbox.misc.Location;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorSourceBuffer
implements ISourceBufferExt {
    protected final ITextEditor editor;
    public static final CommonException CANNOT_SAVE_ReadOnlyView = new CommonException("Cannot save editor, read-only view.");

    public EditorSourceBuffer(ITextEditor editor) {
        this.editor = (ITextEditor)Assert.AssertNamespace.assertNotNull((Object)editor);
    }

    public Location getLocation_orNull() {
        return EditorUtils.getInputLocationOrNull((IEditorPart)this.editor);
    }

    public IDocument getDocument() {
        return EditorUtils.getEditorDocument(this.editor);
    }

    public boolean isDirty() {
        return this.editor.isDirty();
    }

    public void doTrySaveBuffer() throws CommonException, OperationCancellation {
        if (Display.getCurrent() == null) {
            OperationCallable operationCallable = () -> {
                this.saveBuffer();
                return null;
            };
            RunnableFuture2 resultRunnable = operationCallable.toRunnableFuture();
            Display.getDefault().syncExec((Runnable)resultRunnable);
            ((OperationResult)resultRunnable.getResult()).get();
        } else {
            this.saveBuffer();
        }
    }

    protected void saveBuffer() throws CommonException, OperationCancellation {
        new WorkbenchOperationExecutor(true).execute(this::doSaveBuffer);
    }

    public void doSaveBuffer(ICancelMonitor cm) throws OperationCancellation {
        cm.checkCancellation();
        if (this.editor instanceof AbstractLangEditor) {
            AbstractLangEditor langEditor = (AbstractLangEditor)this.editor;
            langEditor.saveWithoutSaveActions2(cm);
        } else {
            this.editor.doSave(EclipseUtils.pm((ICancelMonitor)cm));
        }
    }

    public ISourceBuffer getReadOnlyView() {
        return new EditorSourceBuffer(this.editor){

            @Override
            public void doTrySaveBuffer() throws CommonException {
                throw CANNOT_SAVE_ReadOnlyView;
            }
        };
    }

    public static class DocumentSourceBuffer
    implements ISourceBufferExt {
        protected final IDocument document;

        public DocumentSourceBuffer(IDocument document) {
            this.document = (IDocument)Assert.AssertNamespace.assertNotNull((Object)document);
        }

        public Location getLocation_orNull() {
            return null;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean isDirty() {
            return true;
        }

        public void doTrySaveBuffer() throws CommonException {
            throw new CommonException("Cannot save document for this source buffer");
        }

        public ISourceBuffer getReadOnlyView() {
            return this;
        }
    }
}

