/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import _org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import _org.eclipse.jdt.ui.ProblemsLabelDecorator;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class EditorTitleImageUpdater
implements IProblemChangedListener,
IDisposable {
    protected final AbstractLangEditor editor;
    protected final ProblemsLabelDecorator problemsDecorator = new ProblemsLabelDecorator(LangUIPlugin.getDefault().getImageDescriptorRegistry());

    public EditorTitleImageUpdater(AbstractLangEditor editor) {
        this.editor = (AbstractLangEditor)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)editor)));
        LangUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void dispose() {
        LangUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
        this.problemsDecorator.dispose();
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange, boolean calledFromDisplayThread) {
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.editor.getEditorInput();
        if (input == null) {
            return;
        }
        IFile file = EditorUtils.getAssociatedFile(input);
        IResource[] iResourceArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource changedResource = iResourceArray[n2];
            if (changedResource.equals((Object)file)) {
                this.updateEditorImage(file);
            }
            ++n2;
        }
    }

    public void updateEditorImage(IFile editorFile) {
        Image titleImage = this.editor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image baseImage = this.editor.getBaseEditorImage().getImage();
        Image newImage = this.problemsDecorator.decorateImage(baseImage, editorFile);
        if (titleImage != newImage) {
            this.editor.setTitleImage(newImage);
        }
    }
}

