/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.LangUIPlugin_Actual;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.LangEditorActionContributorHelper;
import melnorme.lang.ide.ui.editor.LangEditorContextMenuContributor;
import melnorme.lang.ide.ui.editor.actions.AbstractEditorHandler;
import melnorme.lang.ide.ui.editor.actions.GoToMatchingBracketHandler;
import melnorme.lang.ide.ui.editor.actions.OpenQuickOutlineHandler;
import melnorme.lang.ide.ui.editor.actions.ToggleCommentHandler;
import melnorme.lang.ide.ui.utils.operations.AbstractEditorOperation2;
import melnorme.lang.ide.ui.utils.operations.BasicUIOperation;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.collections.ArrayList2;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class LangEditorActionContributor
extends LangEditorActionContributorHelper {
    public static final String SOURCE_MENU_ID = String.valueOf(LangUIPlugin.PLUGIN_ID) + ".sourceMenu";
    protected final ArrayList2<IHandlerActivation> handlerActivations = new ArrayList2();

    protected void activateHandler(String string, AbstractHandler handler) {
        IHandlerActivation handlerActivation = this.getHandlerService_2().activateHandler(string, (IHandler)handler);
        this.handlerActivations.add((Object)handlerActivation);
    }

    public final void dispose() {
        this.doDispose();
        for (IHandlerActivation handlerActivation : this.handlerActivations) {
            this.getHandlerService_2().deactivateHandler(handlerActivation);
        }
        super.dispose();
    }

    protected void doDispose() {
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.activateHandler(EditorSettings_Actual.EditorCommandIds.OpenDef_ID, this.getHandler_OpenDefinition());
        this.activateHandler(EditorSettings_Actual.EditorCommandIds.GoToMatchingBracket, this.getHandler_GoToMatchingBracket());
        this.activateHandler(EditorSettings_Actual.EditorCommandIds.ToggleComment, this.getHandler_ToggleComment());
        this.activateHandler(EditorSettings_Actual.EditorCommandIds.QuickOutline, this.getHandler_QuickOutline());
        this.activateHandler(EditorSettings_Actual.EditorCommandIds.Format, this.getHandler_Format());
        this.registerOtherEditorHandlers();
    }

    public AbstractEditorHandler getEditorHandler(final IEditorOperationCreator editorOpCreator) {
        return new AbstractEditorHandler(this.getPage()){

            @Override
            protected BasicUIOperation createOperation(ITextEditor editor) {
                return editorOpCreator.createOperation(editor);
            }
        };
    }

    protected AbstractHandler getHandler_OpenDefinition() {
        return this.getEditorHandler(editor -> {
            EditorUtils.OpenNewEditorMode newEditorMode = EditorUtils.OpenNewEditorMode.TRY_REUSING_EXISTING;
            SourceRange selection = EditorUtils.getSelectionSR(editor);
            return this.createOpenDefinitionOperation(editor, selection, newEditorMode);
        });
    }

    protected AbstractHandler getHandler_GoToMatchingBracket() {
        return new GoToMatchingBracketHandler(this.getPage());
    }

    protected AbstractHandler getHandler_ToggleComment() {
        return new ToggleCommentHandler(this.getPage());
    }

    protected AbstractHandler getHandler_QuickOutline() {
        return new OpenQuickOutlineHandler(this.getPage());
    }

    public AbstractEditorHandler getHandler_Format() {
        return this.getEditorHandler(this.getOpCreator_Format());
    }

    protected abstract AbstractEditorOperation2<?> createOpenDefinitionOperation(ITextEditor var1, SourceRange var2, EditorUtils.OpenNewEditorMode var3);

    protected IEditorOperationCreator getOpCreator_Format() {
        return LangUIPlugin_Actual::getFormatOperation;
    }

    protected abstract void registerOtherEditorHandlers();

    @Override
    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        this.prepareEditMenu(menu);
        this.prepareSourceMenu(menu);
        this.prepareNavigateMenu(menu);
    }

    protected void prepareNavigateMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("show.ext", (IContributionItem)this.pushItem(EditorSettings_Actual.EditorCommandIds.QuickOutline));
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IContributionItem)this.pushItem(EditorSettings_Actual.EditorCommandIds.GoToMatchingBracket));
        }
    }

    protected void prepareEditMenu(IMenuManager menu) {
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("group.assist", (IContributionItem)this.pushItem("org.eclipse.ui.edit.text.contentAssist.proposals", "ContentAssistProposal"));
            editMenu.appendToGroup("group.assist", (IContributionItem)this.pushItem("org.eclipse.ui.edit.text.contentAssist.contextInformation", "ContentAssistContextInformation"));
        }
    }

    protected void prepareSourceMenu(IMenuManager menu) {
        IMenuManager sourceMenu = menu.findMenuUsingPath(SOURCE_MENU_ID);
        if (sourceMenu == null) {
            LangCore.logError((String)("Source menu " + SOURCE_MENU_ID + " not created by plugin.xml!"));
            sourceMenu = LangEditorContextMenuContributor.createSourceMenuSkeleton();
            menu.insertAfter("edit", (IContributionItem)sourceMenu);
        }
        this.contributeSourceMenu(sourceMenu);
    }

    protected void contributeSourceMenu(IMenuManager sourceMenu) {
        EditorSettings_Actual.createCommandsContribHelper(this.getServiceLocator()).contributeSourceMenu(sourceMenu);
    }

    public static interface IEditorOperationCreator {
        public BasicUIOperation createOperation(ITextEditor var1);
    }
}

