/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.core.text.JavaWordFinder;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class LangHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion requestedRegion, boolean canShowMultipleHyperlinks) {
        if (requestedRegion == null) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)requestedRegion.getOffset());
        return (IHyperlink[])CoreUtil.array((Object[])new AbstractLangElementHyperlink[]{this.createHyperlink(requestedRegion, textEditor, wordRegion)});
    }

    protected abstract AbstractLangElementHyperlink createHyperlink(IRegion var1, ITextEditor var2, IRegion var3);

    public static int getEndPos(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    public abstract class AbstractLangElementHyperlink
    implements IHyperlink {
        protected final IRegion region;
        protected final ITextEditor textEditor;

        public AbstractLangElementHyperlink(IRegion region, ITextEditor textEditor) {
            this.region = (IRegion)Assert.AssertNamespace.assertNotNull((Object)region);
            this.textEditor = (ITextEditor)Assert.AssertNamespace.assertNotNull((Object)textEditor);
        }

        public int getOffset() {
            return this.region.getOffset();
        }

        protected SourceRange getElementRange() {
            return new SourceRange(this.region.getOffset(), this.region.getLength());
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return this.getHyperlinkText();
        }

        public String getHyperlinkText() {
            return "Open Definition";
        }
    }
}

