/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;

public abstract class SourceViewerConfigurer
implements IPropertyChangeListener {
    protected final IPreferenceStore store;
    protected final ProjectionViewerExt sourceViewer;
    protected StyledText styledText;

    public SourceViewerConfigurer(IPreferenceStore prefStore, ProjectionViewerExt sourceViewer) {
        this.store = (IPreferenceStore)Assert.AssertNamespace.assertNotNull((Object)prefStore);
        this.sourceViewer = (ProjectionViewerExt)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)sourceViewer)));
    }

    public void configureViewer() {
        this.styledText = this.sourceViewer.getTextWidget();
        Assert.AssertNamespace.assertTrue((boolean)SWTUtil.isOkToUse((Control)this.styledText));
        this.sourceViewer.addConfigurationOwned(new IDisposable(){

            public void dispose() {
                SourceViewerConfigurer.this.unconfigureViewer();
            }
        });
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.doConfigureViewer();
    }

    protected abstract void doConfigureViewer();

    public final void unconfigureViewer() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        this.doUnconfigureViewer();
    }

    protected abstract void doUnconfigureViewer();

    public final void propertyChange(PropertyChangeEvent event) {
        Assert.AssertNamespace.assertTrue((boolean)SWTUtil.isOkToUse((Control)this.styledText));
        this.handlePropertyChange(event);
    }

    protected abstract void handlePropertyChange(PropertyChangeEvent var1);
}

