/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import java.util.List;
import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.lang.ide.ui.editor.SourceViewerConfigurer;
import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ViewerColorUpdater
extends SourceViewerConfigurer {
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    protected static final List<String> PROP_KEY_LIST = CoreUtil.listFrom((Object[])new String[]{"AbstractTextEditor.Color.Foreground", "AbstractTextEditor.Color.Foreground.SystemDefault", "AbstractTextEditor.Color.Background", "AbstractTextEditor.Color.Background.SystemDefault", "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault", "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"});

    public ViewerColorUpdater(IPreferenceStore prefStore, ProjectionViewerExt sourceViewer) {
        super(prefStore, sourceViewer);
    }

    @Override
    protected void doConfigureViewer() {
        this.fForegroundColor = this.updateColorFromSetting(this.fForegroundColor, "AbstractTextEditor.Color.Foreground.SystemDefault", "AbstractTextEditor.Color.Foreground");
        this.styledText.setForeground(this.fForegroundColor);
        this.fBackgroundColor = this.updateColorFromSetting(this.fBackgroundColor, "AbstractTextEditor.Color.Background.SystemDefault", "AbstractTextEditor.Color.Background");
        this.styledText.setBackground(this.fBackgroundColor);
        this.fSelectionForegroundColor = this.updateColorFromSetting(this.fSelectionForegroundColor, "AbstractTextEditor.Color.SelectionForeground.SystemDefault", "AbstractTextEditor.Color.SelectionForeground");
        this.styledText.setSelectionForeground(this.fSelectionForegroundColor);
        this.fSelectionBackgroundColor = this.updateColorFromSetting(this.fSelectionBackgroundColor, "AbstractTextEditor.Color.SelectionBackground.SystemDefault", "AbstractTextEditor.Color.SelectionBackground");
        this.styledText.setSelectionBackground(this.fSelectionBackgroundColor);
    }

    @Override
    protected void doUnconfigureViewer() {
        this.styledText.setForeground(null);
        this.styledText.setBackground(null);
        this.styledText.setSelectionForeground(null);
        this.styledText.setSelectionBackground(null);
        this.fForegroundColor = SWTUtil.dispose(this.fForegroundColor);
        this.fBackgroundColor = SWTUtil.dispose(this.fBackgroundColor);
        this.fSelectionForegroundColor = SWTUtil.dispose(this.fSelectionForegroundColor);
        this.fSelectionBackgroundColor = SWTUtil.dispose(this.fSelectionBackgroundColor);
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (PROP_KEY_LIST.contains(property)) {
            this.doConfigureViewer();
        }
    }

    protected Color updateColorFromSetting(Color currentOwnedColor, String prefKeyUseDefault, String prefKeyColorRgb) {
        if (currentOwnedColor != null) {
            currentOwnedColor.dispose();
        }
        Display display = this.styledText.getDisplay();
        return this.store.getBoolean(prefKeyUseDefault) ? null : this.createColor(this.store, prefKeyColorRgb, display);
    }

    protected Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }
}

