/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.actions;

import java.util.ArrayList;
import java.util.List;
import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.editor.text.LangPairMatcher;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;

public class GotoMatchingBracketManager
implements IDisposable {
    protected final AbstractLangEditor langEditor;
    private List<IRegion> fPreviousSelections;

    public GotoMatchingBracketManager(AbstractLangEditor abstractLangEditor) {
        this.langEditor = abstractLangEditor;
    }

    protected LangPairMatcher getBracketMatcher() {
        return this.langEditor.getBracketMatcher();
    }

    protected void initializePreviousSelectionList() {
        this.fPreviousSelections = new ArrayList<IRegion>(3);
    }

    public void dispose() {
        this.fPreviousSelections.clear();
    }

    public void gotoMatchingBracket() {
        int direction;
        IRegion region;
        LangSourceViewer sourceViewer = this.langEditor.getSourceViewer_();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = EditorUtils.getSignedSelection((ITextViewer)sourceViewer);
        if (this.fPreviousSelections == null) {
            this.initializePreviousSelectionList();
        }
        if ((region = this.getBracketMatcher().match(document, selection.getOffset(), selection.getLength())) == null) {
            region = this.getBracketMatcher().findEnclosingPeerCharacters(document, selection.getOffset(), selection.getLength());
            this.initializePreviousSelectionList();
            this.fPreviousSelections.add(selection);
        } else if (this.fPreviousSelections.size() == 2) {
            if (!selection.equals(this.fPreviousSelections.get(1))) {
                this.initializePreviousSelectionList();
            }
        } else if (this.fPreviousSelections.size() == 3) {
            if (selection.equals(this.fPreviousSelections.get(2)) && !selection.equals(this.fPreviousSelections.get(0))) {
                IRegion originalSelection = this.fPreviousSelections.get(0);
                sourceViewer.setSelectedRange(originalSelection.getOffset(), originalSelection.getLength());
                sourceViewer.revealRange(originalSelection.getOffset(), originalSelection.getLength());
                this.initializePreviousSelectionList();
                return;
            }
            this.initializePreviousSelectionList();
        }
        if (region == null) {
            this.langEditor.setStatusLineErrorMessage("No matching bracket found");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.getBracketMatcher().getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length - 1;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.langEditor.setStatusLineErrorMessage("Matching bracket is outside the selected element");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int adjustment = this.getBracketMatcher().getOffsetAdjustment(document, selection.getOffset() + selection.getLength(), selection.getLength());
        targetOffset += adjustment;
        int n = selection.getLength() == 0 ? 0 : (direction = selection.getLength() > 0 ? 1 : -1);
        if (this.fPreviousSelections.size() == 1 && direction < 0) {
            ++targetOffset;
        }
        if (this.fPreviousSelections.size() > 0) {
            this.fPreviousSelections.add((IRegion)new Region(targetOffset, direction));
        }
        sourceViewer.setSelectedRange(targetOffset, direction);
        sourceViewer.revealRange(targetOffset, direction);
    }
}

