/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.actions;

import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.actions.TextEditorAction_Adapter;
import melnorme.lang.ide.ui.utils.operations.BasicEditorOperation;
import melnorme.utilbox.core.CommonException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleCommentAction
extends TextEditorAction_Adapter {
    private ITextOperationTarget fOperationTarget;
    private String fDocumentPartitioning;
    private Map<String, String[]> fPrefixesMap;

    public ToggleCommentAction(IWorkbenchPage page) {
        super(page);
    }

    protected String getOperationName() {
        return "Toggle Comment";
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.canModifyEditor() && this.isTargetOperationEnabled();
    }

    protected boolean isTargetOperationEnabled() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        return this.fOperationTarget != null && this.fOperationTarget.canDoOperation(11) && this.fOperationTarget.canDoOperation(12);
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        this.fPrefixesMap = null;
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        HashMap<String, String[]> prefixesMap = new HashMap<String, String[]>(types.length);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            String[] prefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (prefixes != null && prefixes.length > 0) {
                int emptyPrefixes = 0;
                int j = 0;
                while (j < prefixes.length) {
                    if (prefixes[j].length() == 0) {
                        ++emptyPrefixes;
                    }
                    ++j;
                }
                if (emptyPrefixes > 0) {
                    String[] nonemptyPrefixes = new String[prefixes.length - emptyPrefixes];
                    int j2 = 0;
                    int k = 0;
                    while (j2 < prefixes.length) {
                        String prefix = prefixes[j2];
                        if (prefix.length() != 0) {
                            nonemptyPrefixes[k] = prefix;
                            ++k;
                        }
                        ++j2;
                    }
                    prefixes = nonemptyPrefixes;
                }
                prefixesMap.put(type, prefixes);
            }
            ++i;
        }
        this.fDocumentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
        this.fPrefixesMap = prefixesMap;
    }

    @Override
    protected BasicEditorOperation createOperation(ITextEditor editor) {
        return new BasicEditorOperation(this.getOperationName(), (IEditorPart)editor){

            @Override
            protected void doRunWithEditor(AbstractLangEditor editor) throws CommonException {
                ToggleCommentAction.this.configure(editor.getSourceViewer_(), (SourceViewerConfiguration)editor.getSourceViewerConfiguration_asLang());
                if (ToggleCommentAction.this.fOperationTarget == null || ToggleCommentAction.this.fDocumentPartitioning == null || ToggleCommentAction.this.fPrefixesMap == null) {
                    throw new CommonException("Partitioning parameters not set");
                }
                if (!ToggleCommentAction.this.validateEditorInputState()) {
                    return;
                }
                if (!ToggleCommentAction.this.isTargetOperationEnabled()) {
                    throw new CommonException("Operation not enabled in target.");
                }
                final int operationCode = ToggleCommentAction.this.isSelectionCommented(editor.getSelectionProvider().getSelection()) ? 12 : 11;
                Display display = ToggleCommentAction.this.getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToggleCommentAction.this.fOperationTarget.doOperation(operationCode);
                    }
                });
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = ToggleCommentAction.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.fDocumentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = ToggleCommentAction.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = this.fPrefixesMap.get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException x) {
            LangCore.logError((String)"Unexpected error.", (Throwable)x);
            return false;
        }
    }

    protected static IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion line = document.getLineInformationOfOffset(selection.getOffset());
            int length = selection.getLength() == 0 ? line.getLength() : selection.getLength() + (selection.getOffset() - line.getOffset());
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException x) {
            LangCore.logError((String)"Unexpected error.", (Throwable)x);
            return null;
        }
    }

    protected static int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        int nextLine;
        int offset;
        block4: {
            try {
                int startLine = document.getLineOfOffset(region.getOffset());
                offset = document.getLineOffset(startLine);
                if (offset >= region.getOffset()) {
                    return startLine;
                }
                nextLine = startLine + 1;
                if (nextLine != document.getNumberOfLines()) break block4;
                return -1;
            }
            catch (BadLocationException x) {
                LangCore.logError((String)"Unexpected error.", (Throwable)x);
                return -1;
            }
        }
        offset = document.getLineOffset(nextLine);
        return offset > region.getOffset() + region.getLength() ? -1 : nextLine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            int i = startLine;
            while (true) {
                if (i > endLine) {
                    return true;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] == -1) {
                    return false;
                }
                String s = document.get(line.getOffset(), found[0]);
                if ((s = s.trim()).length() != 0) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException x) {
            LangCore.logError((String)"Unexpected error.", (Throwable)x);
            return false;
        }
    }
}

